/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature.swamp;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import com.yungnickyoung.minecraft.yungsextras.world.feature.AbstractTemplateFeature;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;

public abstract class AbstractSwampFeature<C extends FeatureConfiguration>
extends AbstractTemplateFeature<C> {
    private static final Set<Material> INVALID_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.f_76296_, Material.f_76305_, Material.f_76307_, Material.f_76301_, Material.f_76300_, Material.f_76304_, Material.f_76302_});
    private static final BlockSetSelector STONE_BRICK_SELECTOR = new BlockSetSelector(Blocks.f_50222_.m_49966_()).addBlock(Blocks.f_50223_.m_49966_(), 0.45f).addBlock(Blocks.f_50224_.m_49966_(), 0.45f);
    private static final BlockSetSelector STONE_BRICK_STAIRS_SELECTOR = new BlockSetSelector(Blocks.f_50194_.m_49966_()).addBlock(Blocks.f_50631_.m_49966_(), 0.6f);
    private static final List<Block> CANDLES = List.of(Blocks.f_152482_, Blocks.f_152483_, Blocks.f_152516_, Blocks.f_152517_, Blocks.f_152521_, Blocks.f_152522_, Blocks.f_152519_, Blocks.f_152524_);

    public AbstractSwampFeature(Codec<C> codec) {
        super(codec);
    }

    @Override
    protected void processTemplate(StructureTemplate template, WorldGenLevel world, Random rand, BlockPos cornerPos, BlockPos centerPos, StructurePlaceSettings placementSettings) {
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50207_)) {
            world.m_7731_(blockInfo.f_74675_, STONE_BRICK_SELECTOR.get(rand), 2);
            BlockPos.MutableBlockPos mutable = blockInfo.f_74675_.m_122032_().m_122173_(Direction.DOWN);
            while (INVALID_MATERIALS.contains(world.m_8055_((BlockPos)mutable).m_60767_())) {
                world.m_7731_((BlockPos)mutable, STONE_BRICK_SELECTOR.get(rand), 2);
                mutable.m_122173_(Direction.DOWN);
            }
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50208_)) {
            world.m_7731_(blockInfo.f_74675_, (BlockState)STONE_BRICK_STAIRS_SELECTOR.get(rand).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(rand)), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50222_)) {
            world.m_7731_(blockInfo.f_74675_, STONE_BRICK_SELECTOR.get(rand), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50194_)) {
            world.m_7731_(blockInfo.f_74675_, (BlockState)((BlockState)((BlockState)((BlockState)STONE_BRICK_STAIRS_SELECTOR.get(rand).m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)blockInfo.f_74676_.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)blockInfo.f_74676_.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)blockInfo.f_74676_.m_61143_((Property)StairBlock.f_56843_)))).m_61124_((Property)StairBlock.f_56844_, (Comparable)((Boolean)blockInfo.f_74676_.m_61143_((Property)StairBlock.f_56844_))), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_152522_)) {
            int numCandles = rand.nextInt(4) + 1;
            boolean lit = rand.nextFloat() < 0.1f;
            world.m_7731_(blockInfo.f_74675_, (BlockState)((BlockState)AbstractSwampFeature.getRandomCandle(rand).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(numCandles))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(lit)), 2);
        }
    }

    private static Block getRandomCandle(Random random) {
        int i = random.nextInt(CANDLES.size());
        return CANDLES.get(i);
    }
}

