/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.services;

import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegister;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterFieldRouter;
import com.yungnickyoung.minecraft.yungsapi.module.BlockEntityTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.BlockModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.CommandModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.CreativeModeTabModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.CriteriaModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.FeatureModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.ItemModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.PlacementModifierTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.SoundEventModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePieceTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePlacementTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePoolElementTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructureProcessorTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructureTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.services.IAutoRegisterHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.class_2960;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class FabricAutoRegisterHelper
implements IAutoRegisterHelper {
    @Override
    public void collectAllAutoRegisterFieldsInPackage(String packageName) {
        Reflections reflections = new Reflections(new ConfigurationBuilder().forPackage(packageName, new ClassLoader[0]).filterInputsBy(new FilterBuilder().includePackage(packageName)).setScanners(Scanners.TypesAnnotated));
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegister.class);
        annotatedClasses.forEach(clazz -> {
            String modId = clazz.getAnnotation(AutoRegister.class).value();
            Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AutoRegister.class)).forEach(field -> {
                Object o;
                field.setAccessible(true);
                String name = field.getAnnotation(AutoRegister.class).value();
                try {
                    o = field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                class_2960 resourceLocation = new class_2960(modId, name);
                AutoRegisterField autoRegisterField = new AutoRegisterField(o, resourceLocation);
                AutoRegisterFieldRouter.queueField(autoRegisterField);
            });
        });
    }

    @Override
    public void invokeAllAutoRegisterMethods(String packageName) {
        Reflections reflections = new Reflections(new ConfigurationBuilder().forPackage(packageName, new ClassLoader[0]).filterInputsBy(new FilterBuilder().includePackage(packageName)).setScanners(Scanners.TypesAnnotated));
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegister.class);
        annotatedClasses.forEach(clazz -> Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(AutoRegister.class)).forEach(method -> {
            method.setAccessible(true);
            try {
                method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                YungsApiCommon.LOGGER.error("Unable to invoke method {} - make sure it's static and has no args!", (Object)method.getName());
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public void processQueuedAutoRegEntries() {
        SoundEventModuleFabric.processEntries();
        CommandModuleFabric.processEntries();
        StructurePieceTypeModuleFabric.processEntries();
        StructurePoolElementTypeModuleFabric.processEntries();
        CriteriaModuleFabric.processEntries();
        StructureTypeModuleFabric.processEntries();
        FeatureModuleFabric.processEntries();
        PlacementModifierTypeModuleFabric.processEntries();
        CreativeModeTabModuleFabric.processEntries();
        ItemModuleFabric.processEntries();
        BlockModuleFabric.processEntries();
        BlockEntityTypeModuleFabric.processEntries();
        StructureProcessorTypeModuleFabric.processEntries();
        StructurePlacementTypeModuleFabric.processEntries();
    }
}

