/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePoolElementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.condition.ConditionContext;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureConditionType;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_3781;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_5497;
import net.minecraft.class_5699;
import net.minecraft.class_6880;

public class YungJigsawSinglePoolElement
extends class_3781 {
    public static final Codec<YungJigsawSinglePoolElement> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)YungJigsawSinglePoolElement.method_28882(), (App)YungJigsawSinglePoolElement.method_28880(), (App)YungJigsawSinglePoolElement.method_28883(), (App)Codec.STRING.optionalFieldOf("name").forGetter(element -> element.name), (App)class_5699.field_33441.optionalFieldOf("max_count").forGetter(element -> element.maxCount), (App)class_5699.field_33441.optionalFieldOf("min_required_depth").forGetter(element -> element.minRequiredDepth), (App)class_5699.field_33441.optionalFieldOf("max_possible_depth").forGetter(element -> element.maxPossibleDepth), (App)Codec.BOOL.optionalFieldOf("is_priority", (Object)false).forGetter(element -> element.isPriority), (App)Codec.BOOL.optionalFieldOf("ignore_bounds", (Object)false).forGetter(element -> element.ignoreBounds), (App)StructureConditionType.CONDITION_CODEC.optionalFieldOf("condition").forGetter(element -> element.condition)).apply((Applicative)builder, YungJigsawSinglePoolElement::new));
    public final Optional<Integer> maxCount;
    public final Optional<String> name;
    public final Optional<Integer> minRequiredDepth;
    public final Optional<Integer> maxPossibleDepth;
    public final boolean isPriority;
    public final boolean ignoreBounds;
    public final Optional<StructureCondition> condition;

    public YungJigsawSinglePoolElement(Either<class_2960, class_3499> resourceLocation, class_6880<class_5497> processors, class_3785.class_3786 projection, Optional<String> name, Optional<Integer> maxCount, Optional<Integer> minRequiredDepth, Optional<Integer> maxPossibleDepth, boolean isPriority, boolean ignoreBounds, Optional<StructureCondition> condition) {
        super(resourceLocation, processors, projection);
        this.maxCount = maxCount;
        this.name = name;
        this.minRequiredDepth = minRequiredDepth;
        this.maxPossibleDepth = maxPossibleDepth;
        this.isPriority = isPriority;
        this.ignoreBounds = ignoreBounds;
        this.condition = condition;
    }

    public class_3816<?> method_16757() {
        return StructurePoolElementTypeModule.YUNG_SINGLE_ELEMENT;
    }

    public boolean isPriorityPiece() {
        return this.isPriority;
    }

    public boolean ignoresBounds() {
        return this.ignoreBounds;
    }

    public boolean isAtValidDepth(int depth) {
        boolean isAtMinRequiredDepth = this.minRequiredDepth.isEmpty() || this.minRequiredDepth.get() <= depth;
        boolean isAtMaxAllowableDepth = this.maxPossibleDepth.isEmpty() || this.maxPossibleDepth.get() >= depth;
        return isAtMinRequiredDepth && isAtMaxAllowableDepth;
    }

    public boolean passesConditions(ConditionContext ctx) {
        return this.condition.isEmpty() || this.condition.get().passes(ctx);
    }

    public String toString() {
        return String.format("YungJigsawSingle[%s][%s][%s][%s][%s][%s]", this.name, this.field_24015, this.maxCount.isPresent() ? this.maxCount.get() : "N/A", this.minRequiredDepth.isPresent() ? "" + this.minRequiredDepth.get() : "N/A", this.maxPossibleDepth.isPresent() ? "" + this.maxPossibleDepth.get() : "N/A", this.isPriority);
    }
}

