/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.world.condition.ConditionContext;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.IMaxCountJigsawPiece;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.YungJigsawSinglePoolElement;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawManager {
    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext generationContext, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawNameOptional, int maxDepth, BlockPos startPos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY) {
        BlockPos blockPos;
        RegistryAccess registryAccess = generationContext.f_226621_();
        ChunkGenerator chunkGenerator = generationContext.f_226622_();
        StructureTemplateManager structureManager = generationContext.f_226625_();
        LevelHeightAccessor levelHeightAccessor = generationContext.f_226629_();
        WorldgenRandom worldgenRandom = generationContext.f_226626_();
        Registry registry = registryAccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_221990_((RandomSource)worldgenRandom);
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)startPool.m_203334_();
        StructurePoolElement startPieceBlueprint = structureTemplatePool.m_227355_((RandomSource)worldgenRandom);
        if (startPieceBlueprint == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (startJigsawNameOptional.isPresent()) {
            ResourceLocation name = startJigsawNameOptional.get();
            Optional<BlockPos> optional = JigsawManager.getPosOfJigsawBlockWithName(startPieceBlueprint, name, startPos, rotation, structureManager, worldgenRandom);
            if (optional.isEmpty()) {
                YungsApiCommon.LOGGER.error("No starting jigsaw with Name {} found in start pool {}", (Object)name, (Object)((ResourceKey)startPool.m_203543_().get()).m_135782_());
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = startPos;
        }
        BlockPos startingPosOffset = blockPos.m_121996_((Vec3i)startPos);
        BlockPos adjustedStartPos = startPos.m_121996_((Vec3i)startingPosOffset);
        PoolElementStructurePiece startPiece = new PoolElementStructurePiece(structureManager, startPieceBlueprint, adjustedStartPos, startPieceBlueprint.m_210540_(), rotation, startPieceBlueprint.m_214015_(structureManager, adjustedStartPos, rotation));
        BoundingBox pieceBoundingBox = startPiece.m_73547_();
        int pieceCenterX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int pieceCenterZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int pieceCenterY = projectStartToHeightmap.map(types -> startPos.m_123342_() + chunkGenerator.m_223221_(pieceCenterX, pieceCenterZ, types, levelHeightAccessor, generationContext.f_226624_())).orElseGet(() -> ((BlockPos)adjustedStartPos).m_123342_());
        int yAdjustment = pieceBoundingBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, pieceCenterY - yAdjustment, 0);
        int adjustedPieceCenterY = pieceCenterY + startingPosOffset.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(pieceCenterX, adjustedPieceCenterY, pieceCenterZ), structurePiecesBuilder -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(startPiece);
            if (maxDepth <= 0) {
                return;
            }
            AABB aABB = new AABB((double)(pieceCenterX - maxDistanceFromCenter), (double)(adjustedPieceCenterY - maxDistanceFromCenter), (double)(pieceCenterZ - maxDistanceFromCenter), (double)(pieceCenterX + maxDistanceFromCenter + 1), (double)(adjustedPieceCenterY + maxDistanceFromCenter + 1), (double)(pieceCenterZ + maxDistanceFromCenter + 1));
            BoxOctree maxStructureBounds = new BoxOctree(aABB);
            maxStructureBounds.addBox(AABB.m_82321_((BoundingBox)pieceBoundingBox));
            Assembler assembler = new Assembler((Registry<StructureTemplatePool>)registry, maxDepth, chunkGenerator, structureManager, pieces, (RandomSource)worldgenRandom, maxY, minY);
            PieceEntry startPieceEntry = new PieceEntry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)maxStructureBounds), 0);
            assembler.pieceQueue.addLast(startPieceEntry);
            while (!assembler.pieceQueue.isEmpty()) {
                PieceEntry entry = assembler.pieceQueue.removeFirst();
                assembler.processPiece(entry.piece, entry.boxOctreeMutableObject, entry.depth, useExpansionHack, levelHeightAccessor, generationContext.f_226624_());
            }
            pieces.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        }));
    }

    private static Optional<BlockPos> getPosOfJigsawBlockWithName(StructurePoolElement startPieceBlueprint, ResourceLocation name, BlockPos startPos, Rotation rotation, StructureTemplateManager structureTemplateManager, WorldgenRandom worldgenRandom) {
        List shuffledJigsawBlocks = startPieceBlueprint.m_213638_(structureTemplateManager, startPos, rotation, (RandomSource)worldgenRandom);
        for (StructureTemplate.StructureBlockInfo jigsawBlockInfo : shuffledJigsawBlocks) {
            ResourceLocation jigsawBlockName = ResourceLocation.m_135820_((String)jigsawBlockInfo.f_74677_.m_128461_("name"));
            if (!name.equals((Object)jigsawBlockName)) continue;
            return Optional.of(jigsawBlockInfo.f_74675_);
        }
        return Optional.empty();
    }

    public static final class Assembler {
        private final Registry<StructureTemplatePool> poolRegistry;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource rand;
        public final Deque<PieceEntry> pieceQueue = Queues.newArrayDeque();
        private final Map<String, Integer> pieceCounts;
        private final Map<String, Integer> maxPieceCounts;
        private final Optional<Integer> maxY;
        private final Optional<Integer> minY;

        public Assembler(Registry<StructureTemplatePool> poolRegistry, int maxDepth, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> pieces, RandomSource rand, Optional<Integer> maxY, Optional<Integer> minY) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.pieces = pieces;
            this.rand = rand;
            this.pieceCounts = new HashMap<String, Integer>();
            this.maxPieceCounts = new HashMap<String, Integer>();
            this.maxY = maxY;
            this.minY = minY;
        }

        public void processPiece(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctree, int depth, boolean useExpansionHack, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
            StructurePoolElement pieceBlueprint = piece.m_209918_();
            BlockPos piecePos = piece.m_72646_();
            Rotation pieceRotation = piece.m_6830_();
            BoundingBox pieceBoundingBox = piece.m_73547_();
            int pieceMinY = pieceBoundingBox.m_162396_();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.m_213638_(this.structureTemplateManager, piecePos, pieceRotation, this.rand);
            for (StructureTemplate.StructureBlockInfo jigsawBlockInfo : pieceJigsawBlocks) {
                StructurePoolElement generatedPiece;
                MutableObject<BoxOctree> octreeToUse;
                Direction direction = JigsawBlock.m_54250_((BlockState)jigsawBlockInfo.f_74676_);
                BlockPos jigsawBlockPos = jigsawBlockInfo.f_74675_;
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.m_121945_(direction);
                ResourceLocation jigsawBlockPoolId = new ResourceLocation(jigsawBlockInfo.f_74677_.m_128461_("pool"));
                Optional poolOptional = this.poolRegistry.m_6612_(jigsawBlockPoolId);
                if (!poolOptional.isPresent() || ((StructureTemplatePool)poolOptional.get()).m_210590_() == 0 && !Objects.equals(jigsawBlockPoolId, Pools.f_127186_.m_135782_())) {
                    YungsApiCommon.LOGGER.warn("Empty or nonexistent pool: {}", (Object)jigsawBlockPoolId);
                    continue;
                }
                ResourceLocation jigsawBlockFallback = ((StructureTemplatePool)poolOptional.get()).m_210573_();
                Optional fallbackOptional = this.poolRegistry.m_6612_(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((StructureTemplatePool)fallbackOptional.get()).m_210590_() == 0 && !Objects.equals(jigsawBlockFallback, Pools.f_127186_.m_135782_())) {
                    YungsApiCommon.LOGGER.warn("Empty or nonexistent fallback pool: {}", (Object)jigsawBlockFallback);
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.m_71051_((Vec3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(AABB.m_82321_((BoundingBox)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccessor)poolOptional.get()).getRawTemplates()), useExpansionHack, jigsawBlockInfo, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, levelHeightAccessor, randomState)) != null) continue;
                this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccessor)fallbackOptional.get()).getRawTemplates()), useExpansionHack, jigsawBlockInfo, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, levelHeightAccessor, randomState);
            }
        }

        private StructurePoolElement processList(List<Pair<StructurePoolElement, Integer>> candidatePieces, boolean useExpansionHack, StructureTemplate.StructureBlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<BoxOctree> boxOctree, PoolElementStructurePiece piece, int depth, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
            boolean isPieceRigid = piece.m_209918_().m_210539_() == StructureTemplatePool.Projection.RIGID;
            int jigsawBlockRelativeY = jigsawBlockPos.m_123342_() - pieceMinY;
            int surfaceHeight = -1;
            int totalWeightSum = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0 && totalWeightSum > 0) {
                YungJigsawSinglePoolElement yungJigsawPiece;
                Pair<StructurePoolElement, Integer> chosenPiecePair = null;
                for (Pair<StructurePoolElement, Integer> pair : candidatePieces) {
                    YungJigsawSinglePoolElement yungJigsawPiece2;
                    StructurePoolElement candidatePiece = (StructurePoolElement)pair.getFirst();
                    if (!(candidatePiece instanceof YungJigsawSinglePoolElement) || !(yungJigsawPiece2 = (YungJigsawSinglePoolElement)candidatePiece).isPriorityPiece()) continue;
                    chosenPiecePair = pair;
                    break;
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.m_188503_(totalWeightSum) + 1;
                    for (Pair<StructurePoolElement, Integer> candidate : candidatePieces) {
                        if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = candidate;
                        break;
                    }
                }
                StructurePoolElement chosenPiece = (StructurePoolElement)chosenPiecePair.getFirst();
                int n = (Integer)chosenPiecePair.getSecond();
                if (chosenPiece == EmptyPoolElement.f_210175_) {
                    return null;
                }
                if (chosenPiece instanceof YungJigsawSinglePoolElement) {
                    yungJigsawPiece = (YungJigsawSinglePoolElement)chosenPiece;
                    if (yungJigsawPiece.maxCount.isPresent()) {
                        int pieceMaxCount = yungJigsawPiece.maxCount.get();
                        if (yungJigsawPiece.name.isEmpty()) {
                            YungsApiCommon.LOGGER.error("Found YUNG Jigsaw piece with max_count={} missing \"name\" property.", (Object)pieceMaxCount);
                            YungsApiCommon.LOGGER.error("Max count pieces must be named in order to work properly!");
                            YungsApiCommon.LOGGER.error("Ignoring max_count for this piece...");
                        } else {
                            String pieceName = yungJigsawPiece.name.get();
                            if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != pieceMaxCount) {
                                YungsApiCommon.LOGGER.error("YUNG Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)pieceMaxCount, (Object)this.maxPieceCounts.get(pieceName));
                                YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                                YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)pieceMaxCount);
                            }
                            this.maxPieceCounts.put(pieceName, pieceMaxCount);
                            if (this.pieceCounts.getOrDefault(pieceName, 0) >= pieceMaxCount) {
                                totalWeightSum -= n;
                                candidatePieces.remove(chosenPiecePair);
                                continue;
                            }
                        }
                    }
                }
                if (chosenPiece instanceof IMaxCountJigsawPiece) {
                    String pieceName = ((IMaxCountJigsawPiece)chosenPiece).getName();
                    int maxCount = ((IMaxCountJigsawPiece)chosenPiece).getMaxCount();
                    if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != maxCount) {
                        YungsApiCommon.LOGGER.error("Max Count Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)maxCount, (Object)this.maxPieceCounts.get(pieceName));
                        YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                        YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)maxCount);
                    }
                    this.maxPieceCounts.put(pieceName, maxCount);
                    if (this.pieceCounts.getOrDefault(pieceName, 0) >= maxCount) {
                        totalWeightSum -= ((Integer)chosenPiecePair.getSecond()).intValue();
                        candidatePieces.remove(chosenPiecePair);
                        continue;
                    }
                }
                if (chosenPiece instanceof YungJigsawSinglePoolElement && !(yungJigsawPiece = (YungJigsawSinglePoolElement)chosenPiece).isAtValidDepth(depth)) {
                    totalWeightSum -= n;
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (Rotation rotation : Rotation.m_221992_((RandomSource)this.rand)) {
                    List candidateJigsawBlocks = chosenPiece.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, rotation, this.rand);
                    BoundingBox tempCandidateBoundingBox = chosenPiece.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, rotation);
                    int candidateHeightAdjustments = 0;
                    if (useExpansionHack && tempCandidateBoundingBox.m_71057_() <= 16) {
                        candidateHeightAdjustments = candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                            if (!tempCandidateBoundingBox.m_71051_((Vec3i)pieceCandidateJigsawBlock.f_74675_.m_121945_(JigsawBlock.m_54250_((BlockState)pieceCandidateJigsawBlock.f_74676_)))) {
                                return 0;
                            }
                            ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.f_74677_.m_128461_("pool"));
                            Optional candidateTargetPoolOptional = this.poolRegistry.m_6612_(candidateTargetPool);
                            Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(StructureTemplatePool2 -> this.poolRegistry.m_6612_(StructureTemplatePool2.m_210573_()));
                            int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(structureTemplatePool -> structureTemplatePool.m_227357_(this.structureTemplateManager)).orElse(0);
                            int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(structureTemplatePool -> structureTemplatePool.m_227357_(this.structureTemplateManager)).orElse(0);
                            return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                        }).max().orElse(0);
                    }
                    for (StructureTemplate.StructureBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        ConditionContext ctx;
                        YungJigsawSinglePoolElement yungJigsawPiece2;
                        int adjustedCandidatePieceMinY;
                        if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)jigsawBlock, (StructureTemplate.StructureBlockInfo)candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.f_74675_;
                        BlockPos candidateJigsawBlockRelativePos = jigsawBlockTargetPos.m_121996_((Vec3i)candidateJigsawBlockPos);
                        BoundingBox rotatedCandidateBoundingBox = chosenPiece.m_214015_(this.structureTemplateManager, candidateJigsawBlockRelativePos, rotation);
                        StructureTemplatePool.Projection candidatePlacementBehavior = chosenPiece.m_210539_();
                        boolean isCandidateRigid = candidatePlacementBehavior == StructureTemplatePool.Projection.RIGID;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.m_123342_();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_).m_122430_();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_223221_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - rotatedCandidateBoundingBox.m_162396_();
                        BoundingBox adjustedCandidateBoundingBox = rotatedCandidateBoundingBox.m_71045_(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.m_7918_(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.m_162400_() - adjustedCandidateBoundingBox.m_162396_());
                            ((BoundingBoxAccessor)adjustedCandidateBoundingBox).setMaxY(adjustedCandidateBoundingBox.m_162396_() + k2);
                        }
                        if (this.maxY.isPresent() && adjustedCandidateBoundingBox.m_162400_() > this.maxY.get() || this.minY.isPresent() && adjustedCandidateBoundingBox.m_162396_() < this.minY.get()) continue;
                        AABB aabb = AABB.m_82321_((BoundingBox)adjustedCandidateBoundingBox);
                        AABB aabbDeflated = aabb.m_82406_(0.25);
                        boolean pieceIgnoresBounds = false;
                        if (chosenPiece instanceof YungJigsawSinglePoolElement) {
                            YungJigsawSinglePoolElement yungJigsawPiece3 = (YungJigsawSinglePoolElement)chosenPiece;
                            pieceIgnoresBounds = yungJigsawPiece3.ignoresBounds();
                        }
                        if (!pieceIgnoresBounds) {
                            boolean pieceIntersectsExistingPieces = ((BoxOctree)boxOctree.getValue()).intersectsAnyBox(aabbDeflated);
                            boolean pieceIsContainedWithinStructureBoundaries = ((BoxOctree)boxOctree.getValue()).boundaryContains(aabbDeflated);
                            if (pieceIntersectsExistingPieces || !pieceIsContainedWithinStructureBoundaries) continue;
                        }
                        if (chosenPiece instanceof YungJigsawSinglePoolElement && !(yungJigsawPiece2 = (YungJigsawSinglePoolElement)chosenPiece).passesConditions(ctx = new ConditionContext(adjustedCandidateBoundingBox.m_162396_(), adjustedCandidateBoundingBox.m_162400_()))) continue;
                        ((BoxOctree)boxOctree.getValue()).addBox(aabb);
                        int newPieceGroundLevelDelta = piece.m_72647_();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : chosenPiece.m_210540_();
                        PoolElementStructurePiece newPiece = new PoolElementStructurePiece(this.structureTemplateManager, chosenPiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_223221_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.m_209916_(new JigsawJunction(jigsawBlockTargetPos.m_123341_(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.m_123343_(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.m_209916_(new JigsawJunction(jigsawBlockPos.m_123341_(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.m_123343_(), -candidateJigsawYOffsetNeeded, piece.m_209918_().m_210539_()));
                        this.pieces.add((PoolElementStructurePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.pieceQueue.addLast(new PieceEntry(newPiece, boxOctree, depth + 1));
                        }
                        if (chosenPiece instanceof YungJigsawSinglePoolElement) {
                            YungJigsawSinglePoolElement yungJigsawPiece4 = (YungJigsawSinglePoolElement)chosenPiece;
                            if (yungJigsawPiece4.maxCount.isPresent()) {
                                if (yungJigsawPiece4.name.isEmpty()) {
                                    return chosenPiece;
                                }
                                String pieceName = yungJigsawPiece4.name.get();
                                this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                            }
                        }
                        if (chosenPiece instanceof IMaxCountJigsawPiece) {
                            String pieceName = ((IMaxCountJigsawPiece)chosenPiece).getName();
                            this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                        }
                        return chosenPiece;
                    }
                }
                totalWeightSum -= n;
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }

    public record PieceEntry(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctreeMutableObject, int depth) {
    }
}

