/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.smoothboot.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import io.github.ultimateboomer.smoothboot.SmoothBoot;
import io.github.ultimateboomer.smoothboot.config.SmoothBootConfig;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class SmoothBootConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static SmoothBootConfig config;

    public static void readConfig() throws IOException {
        String configPath = System.getProperty("user.dir") + "/config/" + "smoothboot" + ".json";
        SmoothBoot.LOGGER.debug("Config path: " + configPath);
        try (FileReader reader = new FileReader(configPath);){
            config = (SmoothBootConfig)GSON.fromJson((Reader)reader, SmoothBootConfig.class);
            if (config == null) {
                throw new NullPointerException();
            }
            config.validate();
            try (FileWriter writer = new FileWriter(configPath);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            SmoothBoot.LOGGER.debug("Config: " + config);
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            config = new SmoothBootConfig();
            try (FileWriter writer = new FileWriter(configPath);){
                GSON.toJson((Object)config, (Appendable)writer);
                SmoothBoot.LOGGER.debug("New config file created");
            }
        }
    }
}

