/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.smoothboot.mixin;

import io.github.ultimateboomer.smoothboot.SmoothBoot;
import io.github.ultimateboomer.smoothboot.config.SmoothBootConfig;
import io.github.ultimateboomer.smoothboot.config.SmoothBootConfigHandler;
import io.github.ultimateboomer.smoothboot.util.LoggingForkJoinWorkerThread;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Bootstrap;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Util.class})
public abstract class UtilMixin {
    private static boolean initServerExecutor = false;
    @Shadow
    private static ExecutorService field_215091_c;
    @Shadow
    @Final
    private static AtomicInteger field_215090_b;
    @Shadow
    @Final
    private static Logger field_195650_a;

    @Overwrite
    public static Executor func_215072_e() {
        if (!initServerExecutor) {
            field_215091_c = UtilMixin.replWorker("Main");
            initServerExecutor = true;
        }
        return field_215091_c;
    }

    private static ExecutorService replWorker(String name) {
        SmoothBootConfig config = SmoothBootConfigHandler.config;
        ForkJoinPool executorService2 = new ForkJoinPool(MathHelper.func_76125_a((int)config.getMainThreads(), (int)1, (int)Short.MAX_VALUE), forkJoinPool -> {
            String workerName = "Server-Worker-" + name + field_215090_b.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            LoggingForkJoinWorkerThread forkJoinWorkerThread = new LoggingForkJoinWorkerThread(forkJoinPool, field_195650_a);
            forkJoinWorkerThread.setPriority(config.getMainPriority());
            forkJoinWorkerThread.setName(workerName);
            return forkJoinWorkerThread;
        }, (thread, throwable) -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof ReportedException) {
                Bootstrap.func_179870_a((String)((ReportedException)throwable).func_71575_a().func_71502_e());
                System.exit(-1);
            }
            field_195650_a.error(String.format("Caught exception in thread %s", thread), throwable);
        }, true);
        SmoothBoot.LOGGER.info((Object)executorService2);
        return executorService2;
    }
}

