/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.smoothboot.mixin;

import com.google.common.base.Objects;
import io.github.ultimateboomer.smoothboot.SmoothBoot;
import io.github.ultimateboomer.smoothboot.config.SmoothBootConfig;
import io.github.ultimateboomer.smoothboot.config.SmoothBootConfigHandler;
import io.github.ultimateboomer.smoothboot.util.LoggingForkJoinWorkerThread;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Util.class})
public abstract class UtilMixin {
    private static boolean initBootstrapExecutor = false;
    private static boolean initMainWorkerExecutor = false;
    private static boolean initIoWorker = false;
    @Shadow
    private static ExecutorService field_240974_d_;
    @Shadow
    private static ExecutorService field_215091_c;
    @Shadow
    private static ExecutorService field_240975_f_;
    @Shadow
    @Final
    private static AtomicInteger field_215090_b;
    @Shadow
    @Final
    private static Logger field_195650_a;

    @Shadow
    protected static void func_240983_a_(Thread thread, Throwable throwable) {
    }

    @Overwrite
    public static Executor func_240991_e_() {
        if (!initBootstrapExecutor) {
            field_240974_d_ = UtilMixin.replWorker("Bootstrap");
            initBootstrapExecutor = true;
            SmoothBoot.LOGGER.debug("Replaced Bootstrap Executor");
        }
        return field_240974_d_;
    }

    @Overwrite
    public static Executor func_215072_e() {
        if (!initMainWorkerExecutor) {
            field_215091_c = UtilMixin.replWorker("Main");
            initMainWorkerExecutor = true;
            SmoothBoot.LOGGER.debug("Replaced Main Executor");
        }
        return field_215091_c;
    }

    @Overwrite
    public static Executor func_240992_g_() {
        if (!initIoWorker) {
            field_240975_f_ = UtilMixin.replIoWorker();
            initIoWorker = true;
            SmoothBoot.LOGGER.debug("Replaced IO Executor");
        }
        return field_240975_f_;
    }

    private static ExecutorService replWorker(String name) {
        if (SmoothBootConfigHandler.config == null) {
            try {
                SmoothBootConfigHandler.readConfig();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        SmoothBootConfig config = SmoothBootConfigHandler.config;
        ForkJoinPool executorService2 = new ForkJoinPool(MathHelper.func_76125_a((int)UtilMixin.select(name, config.getBootstrapThreads(), config.getMainThreads()), (int)1, (int)Short.MAX_VALUE), forkJoinPool -> {
            String workerName = "Worker-" + name + field_215090_b.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            LoggingForkJoinWorkerThread forkJoinWorkerThread = new LoggingForkJoinWorkerThread(forkJoinPool, field_195650_a);
            forkJoinWorkerThread.setPriority(UtilMixin.select(name, config.getBootstrapPriority(), config.getMainPriority()));
            forkJoinWorkerThread.setName(workerName);
            return forkJoinWorkerThread;
        }, UtilMixin::func_240983_a_, true);
        return executorService2;
    }

    private static ExecutorService replIoWorker() {
        return Executors.newCachedThreadPool(p_240978_0_ -> {
            String workerName = "IO-Worker-" + field_215090_b.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            Thread thread = new Thread(p_240978_0_);
            thread.setName(workerName);
            thread.setPriority(SmoothBootConfigHandler.config.getIoPriority());
            thread.setUncaughtExceptionHandler(UtilMixin::func_240983_a_);
            return thread;
        });
    }

    private static <T> T select(String name, T bootstrap, T main) {
        return Objects.equal((Object)name, (Object)"Bootstrap") ? bootstrap : main;
    }
}

