/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt;

import io.github.strikerrocker.vt.base.Module;
import io.github.strikerrocker.vt.content.ContentModule;
import io.github.strikerrocker.vt.enchantments.EnchantmentModule;
import io.github.strikerrocker.vt.loot.LootModule;
import io.github.strikerrocker.vt.recipes.RecipeModule;
import io.github.strikerrocker.vt.tweaks.TweaksModule;
import io.github.strikerrocker.vt.world.WorldModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vanillatweaks")
public class VanillaTweaks {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "vanillatweaks";
    private static final List<Module> modules = new ArrayList<Module>();

    public VanillaTweaks() {
        VanillaTweaks.registerModules();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::configChanged);
    }

    private static void registerModules() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("VanillaTweaks");
        Collections.addAll(modules, new ContentModule(builder), new EnchantmentModule(builder), new LootModule(builder), new RecipeModule(builder), new TweaksModule(builder), new WorldModule(builder));
        modules.forEach(Module::setupConfig);
        builder.pop();
        ForgeConfigSpec spec = builder.build();
        modules.forEach(module -> module.setConfigSpec(spec));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, spec);
    }

    private void setup(FMLCommonSetupEvent event) {
        modules.forEach(module -> module.setup(event));
        LOGGER.info("Setup Complete");
    }

    private void configChanged(ModConfig.ModConfigEvent event) {
        modules.forEach(module -> module.configChanged(event));
    }
}

