/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.items;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.compat.CuriosCompat;
import io.github.strikerrocker.vt.content.items.BinocularItem;
import io.github.strikerrocker.vt.content.items.ItemConditions;
import io.github.strikerrocker.vt.content.items.SlimeBucketItem;
import io.github.strikerrocker.vt.content.items.craftingpad.CraftingPadItem;
import io.github.strikerrocker.vt.content.items.dynamite.DynamiteEntity;
import io.github.strikerrocker.vt.content.items.dynamite.DynamiteItem;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class Items
extends Feature {
    @ObjectHolder(value="vanillatweaks:dynamite")
    public static final EntityType<DynamiteEntity> DYNAMITE_TYPE = null;
    public static final Item CRAFTING_PAD = new CraftingPadItem();
    public static final Item DYNAMITE = new DynamiteItem();
    private static final Item BINOCULARS = new BinocularItem();
    private static final Item LENS = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("lens");
    private static final Item FRIED_EGG = (Item)new Item(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.6f).func_221453_d()).func_200916_a(ItemGroup.field_78039_h)).setRegistryName("friedegg");
    private static final Item SLIME_BUCKET = new SlimeBucketItem();
    public static ForgeConfigSpec.IntValue dynamiteCooldown;
    public static ForgeConfigSpec.IntValue dynamiteExplosionPower;
    public static ForgeConfigSpec.BooleanValue enablePad;
    static ForgeConfigSpec.BooleanValue enableDynamite;
    static ForgeConfigSpec.BooleanValue enableSlimeBucket;
    static ForgeConfigSpec.DoubleValue binocularZoomAmount;
    static ForgeConfigSpec.BooleanValue enableFriedEgg;

    @SubscribeEvent
    public void onFOVChange(FOVUpdateEvent event) {
        if (event.getEntity() != null && (Double)binocularZoomAmount.get() != 0.0) {
            ItemStack helmet = event.getEntity().func_184582_a(EquipmentSlotType.HEAD);
            if (!helmet.func_190926_b() && helmet.func_77973_b() == BINOCULARS) {
                event.setNewfov((float)((double)event.getFov() / (Double)binocularZoomAmount.get()));
            } else if (ModList.get().isLoaded("curios") && CuriosCompat.isStackInCuriosSlot((LivingEntity)event.getEntity(), new ItemStack((IItemProvider)BINOCULARS))) {
                event.setNewfov((float)((double)event.getFov() / (Double)binocularZoomAmount.get()));
            }
        }
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        enablePad = builder.translation("config.vanillatweaks:enablePad").comment("Do you want a portable crafting table?").define("enablePad", true);
        enableSlimeBucket = builder.translation("config.vanillatweaks:enableSlimeBucket").comment("Want to identity slime chunks in-game?").define("enableSlimeBucket", true);
        enableDynamite = builder.translation("config.vanillatweaks:enableDynamite").comment("Want a less effective but throwable TNT?").define("enableDynamite", true);
        dynamiteCooldown = builder.translation("config.vanillatweaks:dynamiteCooldown").comment("Cooldown for the dynamite in ticks").defineInRange("dynamiteCooldown", 20, 0, Integer.MAX_VALUE);
        dynamiteExplosionPower = builder.translation("config.vanillatweaks:dynamiteExplosionPower").comment("Explosion power for dynamite. TNT has 4, Ender Crystal has 6").defineInRange("dynamiteExplosionPower", 3, 0, 10);
        enableFriedEgg = builder.translation("config.vanillatweaks:enableFriedEgg").comment("Want a food which can be obtained with eggs and heals 2.5 hunger?").define("enableFriedEgg", true);
        binocularZoomAmount = builder.translation("config.vanillatweaks:binocularZoomAmount").comment("How much do you want the binoculars to zoom? ( 0 = disabled)").defineInRange("binocularZoomAmount", 4.0, 0.0, Double.MAX_VALUE);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> DispenserBlock.func_199774_a((IItemProvider)DYNAMITE, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new DynamiteEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        }));
    }

    @Mod.EventBusSubscriber(modid="vanillatweaks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @SubscribeEvent
        public static void onModelRegister(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler(DYNAMITE_TYPE, manager -> new SpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().register(EntityType.Builder.func_220322_a(DynamiteEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> (DynamiteEntity)DYNAMITE_TYPE.func_200721_a(world)).setTrackingRange(64).setUpdateInterval(20).func_206830_a("vanillatweaks:dynamite").setRegistryName(new ResourceLocation("vanillatweaks", "dynamite")));
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            CraftingHelper.register((IConditionSerializer)ItemConditions.Serializer.INSTANCE);
        }

        @SubscribeEvent
        public static void onRegisterItems(RegistryEvent.Register<Item> event) {
            VanillaTweaks.LOGGER.info("Registering Items");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{CRAFTING_PAD, SLIME_BUCKET, DYNAMITE, BINOCULARS, LENS, FRIED_EGG});
        }

        @SubscribeEvent
        public static void sendImc(InterModEnqueueEvent event) {
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.sendImc();
            }
        }
    }
}

