/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.enchantments.EnchantmentFeature;
import io.github.strikerrocker.vt.misc.ConeShape;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HomingEnchantment
extends Enchantment {
    HomingEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.BOW, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        this.setRegistryName("homing");
    }

    @Nullable
    private static LivingEntity getTarget(World world, LivingEntity shooter, int homingLevel) {
        LivingEntity target = null;
        AxisAlignedBB coneBound = ConeShape.getConeBoundApprox(shooter, homingLevel);
        List livingEntities = world.func_217394_a((EntityType)null, coneBound, entity -> !entity.func_110124_au().equals(shooter.func_110124_au()));
        for (Entity entity2 : livingEntities) {
            if (!(entity2 instanceof LivingEntity) || !shooter.func_70685_l(entity2) || entity2 instanceof TameableEntity && ((TameableEntity)entity2).func_184753_b() == shooter.func_110124_au()) continue;
            target = (LivingEntity)entity2;
        }
        VanillaTweaks.LOGGER.debug((Object)coneBound);
        VanillaTweaks.LOGGER.debug(target);
        return target;
    }

    @SubscribeEvent
    public void entityJoin(EntityJoinWorldEvent event) {
        AbstractArrowEntity arrow;
        LivingEntity shooter;
        if (!event.getWorld().func_201670_d() && ((Boolean)EnchantmentFeature.enableHoming.get()).booleanValue() && event.getEntity() instanceof AbstractArrowEntity && (shooter = (LivingEntity)(arrow = (AbstractArrowEntity)event.getEntity()).func_234616_v_()) != null && EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)shooter.func_184614_ca()) > 0) {
            int homingLevel = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)shooter.func_184614_ca());
            LivingEntity target = HomingEnchantment.getTarget(event.getWorld(), shooter, homingLevel);
            if (target != null) {
                double x = target.func_226277_ct_() - arrow.func_226277_ct_();
                double y = target.func_226280_cw_() - arrow.func_226278_cu_();
                double z = target.func_226281_cx_() - arrow.func_226281_cx_();
                arrow.func_189654_d(true);
                arrow.func_70186_c(x, y, z, (float)arrow.func_213322_ci().func_72433_c(), 0.0f);
            }
        }
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent event) {
        if (!event.getEntityLiving().func_130014_f_().func_201670_d()) {
            LivingEntity target;
            LivingEntity player = event.getEntityLiving();
            int homingLvl = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)event.getItem());
            if (homingLvl > 0 && (target = HomingEnchantment.getTarget(event.getEntityLiving().func_130014_f_(), player, homingLvl)) != null) {
                target.func_195064_c(new EffectInstance(Effects.field_188423_x, 4, 1, true, false, false));
            }
        }
    }

    public int func_77321_a(int enchantmentLevel) {
        return (enchantmentLevel - 1) * 10 + 10;
    }

    public int func_223551_b(int enchantmentLevel) {
        return enchantmentLevel * 10 + 51;
    }

    public int func_77325_b() {
        return (Boolean)EnchantmentFeature.enableHoming.get() != false ? 3 : 0;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof BowItem && (Boolean)EnchantmentFeature.enableHoming.get() != false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)EnchantmentFeature.enableHoming.get();
    }

    public boolean func_230309_h_() {
        return (Boolean)EnchantmentFeature.enableHoming.get();
    }
}

