/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.enchantments.EnchantmentFeature;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NimbleEnchantment
extends Enchantment {
    private static final UUID nimbleUUID = UUID.fromString("05b61a62-ae84-492e-8536-f365b7143296");

    NimbleEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentType.ARMOR_FEET, new EquipmentSlotType[]{EquipmentSlotType.FEET});
        this.setRegistryName("nimble");
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (((Boolean)EnchantmentFeature.enableNimble.get()).booleanValue()) {
            LivingEntity entity = event.getEntityLiving();
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)entity.func_184582_a(EquipmentSlotType.FEET));
            ModifiableAttributeInstance speedAttribute = entity.func_110148_a(Attributes.field_233821_d_);
            AttributeModifier speedModifier = new AttributeModifier(nimbleUUID, "Nimble", (double)enchantmentLevel * (double)0.2f, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (enchantmentLevel > 0) {
                if (speedAttribute.func_111127_a(nimbleUUID) == null) {
                    speedAttribute.func_233769_c_(speedModifier);
                }
            } else if (speedAttribute.func_111127_a(nimbleUUID) != null) {
                speedAttribute.func_111124_b(speedModifier);
            }
        }
    }

    public int func_77321_a(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int func_223551_b(int enchantmentLevel) {
        return enchantmentLevel * 10 + 51;
    }

    public int func_77325_b() {
        return (Boolean)EnchantmentFeature.enableNimble.get() != false ? 3 : 0;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_185083_B_().equals((Object)EquipmentSlotType.FEET) && (Boolean)EnchantmentFeature.enableNimble.get() != false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)EnchantmentFeature.enableNimble.get();
    }

    public boolean func_230309_h_() {
        return (Boolean)EnchantmentFeature.enableNimble.get();
    }
}

