/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.enchantments.EnchantmentFeature;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VeteranEnchantment
extends Enchantment {
    VeteranEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.ARMOR_HEAD, new EquipmentSlotType[]{EquipmentSlotType.HEAD});
        this.setRegistryName("veteran");
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (((Boolean)EnchantmentFeature.enableVeteran.get()).booleanValue() && event.world != null && !event.world.func_201670_d()) {
            ServerWorld world = (ServerWorld)event.world;
            world.func_217482_a(EntityType.field_200807_u, EntityPredicates.field_94557_a).forEach(this::attemptToMove);
        }
    }

    private void attemptToMove(Entity xpEntity) {
        double zDiff;
        double yDiff;
        double xDiff;
        double movementFactor;
        double invertedMovementFactor;
        double range = 32.0;
        PlayerEntity closestPlayer = xpEntity.field_70170_p.func_217362_a(xpEntity, range);
        if (closestPlayer != null && EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)closestPlayer.func_184582_a(EquipmentSlotType.HEAD)) > 0 && (invertedMovementFactor = 1.0 - (movementFactor = Math.sqrt((xDiff = (closestPlayer.func_226277_ct_() - xpEntity.func_226277_ct_()) / range) * xDiff + (yDiff = (closestPlayer.func_226278_cu_() + (double)closestPlayer.func_70047_e() - xpEntity.func_226278_cu_()) / range) * yDiff + (zDiff = (closestPlayer.func_226281_cx_() - xpEntity.func_226281_cx_()) / range) * zDiff))) > 0.0) {
            invertedMovementFactor *= invertedMovementFactor;
            Vector3d motion = xpEntity.func_213322_ci();
            xpEntity.func_213293_j(motion.field_72450_a + xDiff / movementFactor * invertedMovementFactor * 0.1, motion.field_72448_b + yDiff / movementFactor * invertedMovementFactor * 0.1, motion.field_72449_c + zDiff / movementFactor * invertedMovementFactor * 0.1);
        }
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10;
    }

    public int func_223551_b(int enchantmentLevel) {
        return 40;
    }

    public int func_77325_b() {
        return (Boolean)EnchantmentFeature.enableVeteran.get() != false ? 1 : 0;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_185083_B_().equals((Object)EquipmentSlotType.HEAD) && (Boolean)EnchantmentFeature.enableVeteran.get() != false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)EnchantmentFeature.enableVeteran.get();
    }

    public boolean func_230309_h_() {
        return (Boolean)EnchantmentFeature.enableVeteran.get();
    }
}

