/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.misc;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class ConeShape {
    private static double max5(double a, double b, double c, double d, double e) {
        return Math.max(Math.max(Math.max(Math.max(a, b), c), d), e);
    }

    private static double min5(double a, double b, double c, double d, double e) {
        return Math.min(Math.min(Math.min(Math.min(a, b), c), d), e);
    }

    public static AxisAlignedBB getConeBoundApprox(LivingEntity livingEntity, int enchantmentLvl) {
        double length = Math.pow(2.0, (double)enchantmentLvl - 1.0) * 16.0;
        float radius = 2.0f;
        float hyp = (float)Math.sqrt((double)(radius * radius) + length * length);
        Vector3d p0 = livingEntity.func_174824_e(1.0f);
        float y = livingEntity.field_70759_as;
        float p = livingEntity.field_70125_A;
        float f = (float)Math.toDegrees(Math.atan2(radius, length));
        Vector3d v0 = ConeShape.getVectorFromRPY(hyp, y, p, 0.0f - f);
        Vector3d v1 = ConeShape.getVectorFromRPY(hyp, y, p, 0.0f + f);
        Vector3d v2 = ConeShape.getVectorFromRPY(hyp, y, p - f, 0.0);
        Vector3d v3 = ConeShape.getVectorFromRPY(hyp, y, p + f, 0.0);
        Vector3d q0 = p0.func_178787_e(v0);
        Vector3d q1 = p0.func_178787_e(v1);
        Vector3d q2 = p0.func_178787_e(v2);
        Vector3d q3 = p0.func_178787_e(v3);
        float mx = (float)ConeShape.max5(p0.field_72450_a, q0.field_72450_a, q1.field_72450_a, q2.field_72450_a, q3.field_72450_a);
        float nx = (float)ConeShape.min5(p0.field_72450_a, q0.field_72450_a, q1.field_72450_a, q2.field_72450_a, q3.field_72450_a);
        float my = (float)ConeShape.max5(p0.field_72448_b, q0.field_72448_b, q1.field_72448_b, q2.field_72448_b, q3.field_72448_b);
        float ny = (float)ConeShape.min5(p0.field_72448_b, q0.field_72448_b, q1.field_72448_b, q2.field_72448_b, q3.field_72448_b);
        float mz = (float)ConeShape.max5(p0.field_72449_c, q0.field_72449_c, q1.field_72449_c, q2.field_72449_c, q3.field_72449_c);
        float nz = (float)ConeShape.min5(p0.field_72449_c, q0.field_72449_c, q1.field_72449_c, q2.field_72449_c, q3.field_72449_c);
        return new AxisAlignedBB((double)mx, (double)my, (double)mz, (double)nx, (double)ny, (double)nz);
    }

    private static Vector3d getVectorFromRPY(double length, double y, double p, double r) {
        y = Math.toRadians(y + 90.0);
        p = Math.toRadians(180.0 - p);
        r = Math.toRadians(r + 180.0);
        double y2 = y + Math.toRadians(90.0);
        double ll = length * Math.cos(r);
        double ss = length * Math.sin(r);
        double xz = ll * Math.cos(p);
        double yy = ll * Math.sin(p);
        double xl = xz * Math.cos(y);
        double zl = xz * Math.sin(y);
        double xs = ss * Math.cos(y2);
        double zs = ss * Math.sin(y2);
        double xx = xl + xs;
        double zz = zl + zs;
        return new Vector3d(xx, yy, zz);
    }
}

