/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArmorStandSwap
extends Feature {
    private ForgeConfigSpec.BooleanValue enableArmorStandSwapping;

    private static void swapSlot(PlayerEntity player, ArmorStandEntity armorStand, EquipmentSlotType slot) {
        ItemStack playerItem = player.func_184582_a(slot);
        ItemStack armorStandItem = armorStand.func_184582_a(slot);
        player.func_184201_a(slot, armorStandItem);
        armorStand.func_184201_a(slot, playerItem);
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableArmorStandSwapping = builder.translation("config.vanillatweaks:enableArmorStandSwapping").comment("Want an way to swap armor with armor stand?").define("enableArmorStandSwapping", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        if (player.func_213453_ef() && ((Boolean)this.enableArmorStandSwapping.get()).booleanValue()) {
            if (target.field_70170_p.func_201670_d() || player.func_175149_v() || player.func_184812_l_() || !(target instanceof ArmorStandEntity)) {
                return;
            }
            event.setCanceled(true);
            ArmorStandEntity armorStand = (ArmorStandEntity)target;
            for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
                if (equipmentSlotType.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ArmorStandSwap.swapSlot(player, armorStand, equipmentSlotType);
            }
        }
    }
}

