/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArrowSetFire
extends Feature {
    private ForgeConfigSpec.BooleanValue arrowsSetBlockOnFire;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.arrowsSetBlockOnFire = builder.translation("config.vanillatweaks:arrowsSetBlockOnFire").comment("Want the fire arrows to set fire on block it landed?").define("arrowsSetBlockOnFire", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onArrowImpact(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity arrow = event.getArrow();
        if (!arrow.field_70170_p.func_201670_d() && arrow.func_70027_ad() && ((Boolean)this.arrowsSetBlockOnFire.get()).booleanValue()) {
            Vector3d vec3d = arrow.func_213303_ch().func_178787_e(arrow.func_213322_ci());
            BlockRayTraceResult raytraceresult = arrow.field_70170_p.func_217299_a(new RayTraceContext(arrow.func_213303_ch(), vec3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)arrow));
            BlockPos hitPos = new BlockPos(raytraceresult.func_216347_e()).func_177984_a();
            if (arrow.field_70170_p.func_175623_d(hitPos)) {
                arrow.field_70170_p.func_175656_a(hitPos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }
}

