/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BeehiveTooltips
extends Feature {
    private ForgeConfigSpec.BooleanValue enableBeehiveTooltips;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableBeehiveTooltips = builder.translation("config.vanillatweaks:enableBeehiveTooltips").comment("Want to see the no of bees or the honey level of an beehive?").define("enableBeehiveTooltips", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onToolTipEvent(ItemTooltipEvent event) {
        CompoundNBT tag;
        if (event.getFlags().func_194127_a() && ((Boolean)this.enableBeehiveTooltips.get()).booleanValue() && event.getItemStack().func_77973_b() instanceof BlockItem && ((BlockItem)event.getItemStack().func_77973_b()).func_179223_d() instanceof BeehiveBlock && (tag = event.getItemStack().func_77978_p()) != null) {
            CompoundNBT beTag = tag.func_74775_l("BlockEntityTag");
            ListNBT bees = beTag.func_150295_c("Bees", 10);
            int numBees = bees.size();
            CompoundNBT blockStateTag = tag.func_74775_l("BlockStateTag");
            String honeyLvl = blockStateTag.func_74779_i("honey_level");
            System.out.println("bees " + bees);
            System.out.println("lvl " + honeyLvl);
            event.getToolTip().add(new TranslationTextComponent("vanillatweaks.bees").func_230529_a_((ITextComponent)new StringTextComponent(String.format("%d", numBees))));
            event.getToolTip().add(new TranslationTextComponent("vanillatweaks.honey.lvl").func_230529_a_((ITextComponent)new StringTextComponent(String.format("%s", honeyLvl))));
        }
    }
}

