/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobsBurnInDaylight
extends Feature {
    private ForgeConfigSpec.BooleanValue babyZombieBurnInDaylight;
    private ForgeConfigSpec.BooleanValue creeperBurnInDaylight;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.babyZombieBurnInDaylight = builder.translation("config.vanillatweaks:babyZombieBurnInDaylight").comment("Want baby zombies to burn by the light of the day?").define("babyZombieBurnInDaylight", true);
        this.creeperBurnInDaylight = builder.translation("config.vanillatweaks:creeperBurnInDaylight").comment("Want creeper's to burn in daylight?").define("creeperBurnInDaylight", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.func_201670_d()) {
            World world = livingEntity.field_70170_p;
            if ((livingEntity instanceof CreeperEntity && ((Boolean)this.creeperBurnInDaylight.get()).booleanValue() || livingEntity instanceof ZombieEntity && livingEntity.func_70631_g_() && ((Boolean)this.babyZombieBurnInDaylight.get()).booleanValue()) && world.func_72935_r()) {
                float brightness = livingEntity.func_70013_c();
                Random random = world.field_73012_v;
                BlockPos blockPos = livingEntity.func_233580_cy_();
                if ((double)brightness > 0.5 && (double)(random.nextFloat() * 30.0f) < ((double)brightness - 0.4) * 2.0 && world.func_226660_f_(blockPos)) {
                    livingEntity.func_70015_d(10);
                }
            }
        }
    }
}

