/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Module;
import io.github.strikerrocker.vt.enchantments.BlazingEnchantment;
import io.github.strikerrocker.vt.enchantments.HomingEnchantment;
import io.github.strikerrocker.vt.enchantments.HopsEnchantment;
import io.github.strikerrocker.vt.enchantments.NimbleEnchantment;
import io.github.strikerrocker.vt.enchantments.SiphonEnchantment;
import io.github.strikerrocker.vt.enchantments.VeteranEnchantment;
import io.github.strikerrocker.vt.enchantments.VigorEnchantment;
import io.github.strikerrocker.vt.events.EntityEquipmentChangeCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5575;

public class EnchantmentModule
extends Module {
    public static final Map<String, class_1887> enchantments = new HashMap<String, class_1887>();
    private static final UUID nimbleUUID = UUID.fromString("05b61a62-ae84-492e-8536-f365b7143296");
    private static final UUID vigorUUID = UUID.fromString("18339f34-6ab5-461d-a103-9b9a3ac3eec7");

    @Override
    public void initialize() {
        enchantments.put("blazing", (class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("vanillatweaks", "blazing"), (Object)((Object)new BlazingEnchantment())));
        enchantments.put("hops", (class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("vanillatweaks", "hops"), (Object)((Object)new HopsEnchantment())));
        enchantments.put("nimble", (class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("vanillatweaks", "nimble"), (Object)((Object)new NimbleEnchantment())));
        enchantments.put("siphon", (class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("vanillatweaks", "siphon"), (Object)((Object)new SiphonEnchantment())));
        enchantments.put("veteran", (class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("vanillatweaks", "veteran"), (Object)((Object)new VeteranEnchantment())));
        enchantments.put("vigor", (class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("vanillatweaks", "vigor"), (Object)((Object)new VigorEnchantment())));
        enchantments.put("homing", (class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("vanillatweaks", "homing"), (Object)((Object)new HomingEnchantment())));
        super.initialize();
        EntityEquipmentChangeCallback.EVENT.register((entity, slot, from, to) -> {
            int lvl;
            if (VanillaTweaks.config.enchanting.enableNimble) {
                int enchantmentLevel = class_1890.method_8225((class_1887)enchantments.get("nimble"), (class_1799)entity.method_6118(class_1304.field_6166));
                class_1324 speedAttribute = entity.method_6127().method_26842(class_5134.field_23719);
                class_1322 speedModifier = new class_1322(nimbleUUID, "Nimble", (double)enchantmentLevel * (double)0.2f, class_1322.class_1323.field_6331);
                if (enchantmentLevel > 0) {
                    if (speedAttribute.method_6199(nimbleUUID) == null) {
                        speedAttribute.method_26837(speedModifier);
                    }
                } else if (speedAttribute.method_6199(nimbleUUID) != null) {
                    speedAttribute.method_6202(speedModifier);
                }
            }
            if (VanillaTweaks.config.enchanting.enableVigor) {
                lvl = class_1890.method_8225((class_1887)enchantments.get("vigor"), (class_1799)entity.method_6118(class_1304.field_6174));
                class_1324 vigorAttribute = entity.method_6127().method_26842(class_5134.field_23716);
                class_1322 vigorModifier = new class_1322(vigorUUID, "vigor", (double)((float)lvl / 10.0f), class_1322.class_1323.field_6330);
                if (lvl > 0) {
                    if (vigorAttribute.method_6199(vigorUUID) == null) {
                        vigorAttribute.method_26837(vigorModifier);
                    }
                } else if (vigorAttribute.method_6199(vigorUUID) != null) {
                    vigorAttribute.method_6202(vigorModifier);
                    if (entity.method_6032() > entity.method_6063()) {
                        entity.method_6033(entity.method_6063());
                    }
                }
            }
            if (VanillaTweaks.config.enchanting.enableHops) {
                lvl = class_1890.method_8225((class_1887)enchantments.get("hops"), (class_1799)entity.method_6118(class_1304.field_6166));
                if (lvl > 0) {
                    if (!entity.method_6059(class_1294.field_5913)) {
                        entity.method_6092(new class_1293(class_1294.field_5913, Integer.MAX_VALUE, lvl, true, false, false));
                    }
                } else if (entity.method_6059(class_1294.field_5913)) {
                    entity.method_6016(class_1294.field_5913);
                }
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(serverWorld -> {
            if (VanillaTweaks.config.enchanting.enableVeteran && serverWorld != null && !serverWorld.field_9236) {
                serverWorld.method_18198((class_5575)class_1299.field_6044, class_1301.field_6154).forEach(VeteranEnchantment::attemptToMove);
            }
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            class_1297 arrow$temp = entity;
            if (arrow$temp instanceof class_1667) {
                class_1297 player$temp;
                class_1667 arrow = (class_1667)arrow$temp;
                if (VanillaTweaks.config.enchanting.enableHoming && (player$temp = arrow.method_24921()) instanceof class_1657) {
                    class_1657 player = (class_1657)player$temp;
                    for (class_1799 stack : player.method_5877()) {
                        int lvl = class_1890.method_8225((class_1887)enchantments.get("homing"), (class_1799)stack);
                        if (lvl <= 0) continue;
                        double distance = Math.pow(2.0, lvl - 1) * 32.0;
                        List entityList = world.method_8333((class_1297)player, new class_238(player.method_24515()).method_1014(distance), class_1301.field_6154);
                        class_1309 target = null;
                        for (class_1297 entity1 : entityList) {
                            class_1297 livingEntity$temp = entity1;
                            if (!(livingEntity$temp instanceof class_1309)) continue;
                            class_1309 livingEntity = (class_1309)livingEntity$temp;
                            double distanceToArrow = entity1.method_5739((class_1297)arrow);
                            if (!(distanceToArrow < distance) || !player.method_6057((class_1297)livingEntity) || livingEntity.method_5667().equals(arrow.method_5667())) continue;
                            distance = distanceToArrow;
                            target = (class_1309)entity1;
                        }
                        if (target == null) continue;
                        double x1 = target.method_23317() - arrow.method_23317();
                        double y1 = target.method_5829().field_1322 + (double)(target.method_17682() / 2.0f) - (arrow.method_23318() + (double)(arrow.method_17682() / 2.0f));
                        double z1 = target.method_23321() - arrow.method_23321();
                        arrow.method_7485(x1, y1, z1, (float)arrow.method_18798().method_1033(), 0.0f);
                    }
                }
            }
        });
    }

    @Override
    public void addFeatures() {
    }
}

