/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.blocks;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalBlock;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalBlockEntity;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalContainer;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalRenderer;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockInit
extends Feature {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"vanillatweaks");
    public static final DeferredRegister<MenuType<?>> MENU_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"vanillatweaks");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"vanillatweaks");
    public static final RegistryObject<Block> PEDESTAL_BLOCK = BLOCKS.register("pedestal", PedestalBlock::new);
    public static final RegistryObject<Block> CHARCOAL_BLOCK = BLOCKS.register("charcoalblock", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(5.0f, 10.0f)));
    public static final RegistryObject<Block> SUGAR_BLOCK = BLOCKS.register("sugarblock", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76372_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
    public static final RegistryObject<Block> FLINT_BLOCK = BLOCKS.register("flintblock", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76362_).m_60913_(1.0f, 10.0f)));
    public static final RegistryObject<MenuType<PedestalContainer>> PEDESTAL_MENU_TYPE = MENU_TYPE.register("pedestal", () -> IForgeContainerType.create((windowId, inv, data) -> new PedestalContainer(windowId, inv, data.m_130135_())));
    public static final RegistryObject<BlockEntityType<PedestalBlockEntity>> PEDESTAL_TYPE = BLOCK_ENTITY_TYPE.register("pedestal", () -> BlockEntityType.Builder.m_155273_(PedestalBlockEntity::new, (Block[])new Block[]{(Block)PEDESTAL_BLOCK.get()}).m_58966_(null));
    static ForgeConfigSpec.BooleanValue enableStorageBlocks;
    static ForgeConfigSpec.BooleanValue enablePedestal;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        enablePedestal = builder.translation("config.vanillatweaks:enablePedestal").comment("Want to showcase your treasure but item frame doesn't satisfy you?").define("enablePedestal", true);
        enableStorageBlocks = builder.translation("config.vanillatweaks:enableStorageBlocks").comment("Want block forms of flint, charcoal and sugar?").define("enableStorageBlocks", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item == ((Block)CHARCOAL_BLOCK.get()).m_5456_()) {
            event.setBurnTime(16000);
        }
        if (item == Blocks.f_50081_.m_5456_()) {
            event.setBurnTime(400);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            MenuScreens.m_96206_((MenuType)((MenuType)PEDESTAL_MENU_TYPE.get()), PedestalScreen::new);
            event.registerBlockEntityRenderer((BlockEntityType)PEDESTAL_TYPE.get(), PedestalRenderer::new);
        }
    }
}

