/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.blocks.pedestal;

import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalBlockEntity;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class PedestalBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final VoxelShape base = Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)1.0, (double)15.5);
    private final VoxelShape deco1 = Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private final VoxelShape pillar = Block.m_49796_((double)4.5, (double)2.0, (double)4.5, (double)11.5, (double)12.0, (double)11.5);
    private final VoxelShape deco2 = Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final VoxelShape top = Block.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private final VoxelShape PEDESTAL_VOXEL_SHAPE = Shapes.m_83124_((VoxelShape)this.base, (VoxelShape[])new VoxelShape[]{this.deco1, this.pillar, this.deco2, this.top});

    public PedestalBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76379_).m_60913_(2.0f, 10.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static PedestalBlockEntity getPedestalTE(LevelReader world, BlockPos pos) {
        return (PedestalBlockEntity)world.m_7702_(pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            ItemStack heldItem = player.m_21120_(handIn);
            PedestalBlockEntity tile = PedestalBlock.getPedestalTE((LevelReader)worldIn, pos);
            if (!player.m_6047_()) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    if (heldItem.m_41619_()) {
                        ItemStack stack = itemHandler.extractItem(0, 64, false);
                        player.m_21008_(handIn, stack);
                    } else {
                        player.m_21008_(handIn, itemHandler.insertItem(0, heldItem, false));
                    }
                });
                tile.m_6596_();
                return InteractionResult.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, playerInv, playerIn) -> new PedestalContainer(id, playerInv, pos), (Component)new TranslatableComponent("block.vanillatweaks.pedestal")), (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.m_5776_()) {
            PedestalBlockEntity tile = PedestalBlock.getPedestalTE((LevelReader)worldIn, pos);
            tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH).ifPresent(itemHandler -> {
                ItemStack stack = itemHandler.getStackInSlot(0);
                if (!stack.m_41619_()) {
                    ItemEntity item = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
                    worldIn.m_7967_((Entity)item);
                }
            });
            worldIn.m_46747_(pos);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.PEDESTAL_VOXEL_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }
}

