/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.enchantments.EnchantmentInit;
import io.github.strikerrocker.vt.misc.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HomingEnchantment
extends Enchantment {
    public HomingEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.BOW, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    @Nullable
    private static LivingEntity getTarget(Level level, LivingEntity shooter, int homingLevel) {
        LivingEntity target = null;
        AABB coneBound = Utils.getConeBoundApprox(shooter, homingLevel);
        List potentialTargets = level.m_45933_((Entity)shooter, coneBound);
        for (Entity entity : potentialTargets) {
            OwnableEntity tamed;
            LivingEntity livingEntity;
            Entity entity2 = entity;
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity2 = (LivingEntity)entity2;
            if (!shooter.m_142582_(entity) || (livingEntity = livingEntity2) instanceof OwnableEntity && (tamed = (OwnableEntity)livingEntity).m_142504_() == shooter.m_142081_()) continue;
            target = livingEntity2;
        }
        VanillaTweaks.LOGGER.debug((Object)coneBound);
        VanillaTweaks.LOGGER.debug(target);
        return target;
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent event) {
        AbstractArrow arrow;
        Entity entity;
        if (!event.getWorld().m_5776_() && ((Boolean)EnchantmentInit.enableHoming.get()).booleanValue() && (entity = event.getEntity()) instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_37282_()) instanceof LivingEntity) {
            LivingEntity target;
            LivingEntity shooter = (LivingEntity)entity;
            int lvl = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentInit.HOMING.get()), (ItemStack)shooter.m_21211_());
            if (lvl > 0 && (target = HomingEnchantment.getTarget(event.getWorld(), shooter, lvl)) != null) {
                double x = target.m_20185_() - arrow.m_20185_();
                double y = target.m_20188_() - arrow.m_20186_();
                double z = target.m_20189_() - arrow.m_20189_();
                arrow.m_20242_(true);
                arrow.m_6686_(x, y, z, (float)arrow.m_20184_().m_82553_(), 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void useItem(LivingEntityUseItemEvent event) {
        if (!event.getEntityLiving().m_20193_().m_5776_()) {
            LivingEntity target;
            LivingEntity player = event.getEntityLiving();
            int homingLvl = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentInit.HOMING.get()), (ItemStack)event.getItem());
            if (homingLvl > 0 && (target = HomingEnchantment.getTarget(event.getEntityLiving().m_20193_(), player, homingLvl)) != null) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 4, 1, true, false, false));
            }
        }
    }

    public int m_6183_(int enchantmentLevel) {
        return (enchantmentLevel - 1) * 10 + 10;
    }

    public int m_6175_(int enchantmentLevel) {
        return enchantmentLevel * 10 + 51;
    }

    public int m_6586_() {
        return (Boolean)EnchantmentInit.enableHoming.get() != false ? 3 : 0;
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof BowItem && (Boolean)EnchantmentInit.enableHoming.get() != false;
    }

    public boolean m_6592_() {
        return (Boolean)EnchantmentInit.enableHoming.get();
    }

    public boolean m_6591_() {
        return (Boolean)EnchantmentInit.homingTreasureOnly.get();
    }

    public boolean m_6594_() {
        return (Boolean)EnchantmentInit.enableHoming.get();
    }
}

