/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.enchantments.EnchantmentInit;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class NimbleEnchantment
extends Enchantment {
    private static final UUID nimbleUUID = UUID.fromString("05b61a62-ae84-492e-8536-f365b7143296");

    NimbleEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_FEET, new EquipmentSlot[]{EquipmentSlot.FEET});
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (((Boolean)EnchantmentInit.enableNimble.get()).booleanValue()) {
            LivingEntity entity = event.getEntityLiving();
            int lvl = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentInit.NIMBLE.get()), (ItemStack)entity.m_6844_(EquipmentSlot.FEET));
            AttributeInstance speedAttribute = entity.m_21051_(Attributes.f_22279_);
            AttributeModifier speedModifier = new AttributeModifier(nimbleUUID, "Nimble", (double)lvl * (double)0.2f, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (speedAttribute != null) {
                if (lvl > 0) {
                    if (speedAttribute.m_22111_(nimbleUUID) == null) {
                        speedAttribute.m_22125_(speedModifier);
                    }
                } else if (speedAttribute.m_22111_(nimbleUUID) != null) {
                    speedAttribute.m_22130_(speedModifier);
                }
            }
        }
    }

    public int m_6183_(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int m_6175_(int enchantmentLevel) {
        return enchantmentLevel * 10 + 51;
    }

    public int m_6586_() {
        return (Boolean)EnchantmentInit.enableNimble.get() != false ? 3 : 0;
    }

    public boolean m_6081_(ItemStack stack) {
        ArmorItem armorItem;
        Item item = stack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_().equals((Object)EquipmentSlot.FEET) && (Boolean)EnchantmentInit.enableNimble.get() != false;
    }

    public boolean m_6592_() {
        return (Boolean)EnchantmentInit.enableNimble.get();
    }

    public boolean m_6591_() {
        return (Boolean)EnchantmentInit.nimbleTreasureOnly.get();
    }

    public boolean m_6594_() {
        return (Boolean)EnchantmentInit.enableNimble.get();
    }
}

