/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.enchantments.EnchantmentInit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VeteranEnchantment
extends Enchantment {
    VeteranEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR_HEAD, new EquipmentSlot[]{EquipmentSlot.HEAD});
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (((Boolean)EnchantmentInit.enableVeteran.get()).booleanValue() && event.world != null && !event.world.m_5776_()) {
            ServerLevel world = (ServerLevel)event.world;
            world.m_143280_((EntityTypeTest)EntityType.f_20570_, EntitySelector.f_20402_).forEach(VeteranEnchantment::attemptToMove);
        }
    }

    private static void attemptToMove(Entity xpEntity) {
        double zDiff;
        double yDiff;
        double xDiff;
        double movementFactor;
        double invertedMovementFactor;
        double range = 32.0;
        Player closestPlayer = xpEntity.f_19853_.m_45930_(xpEntity, range);
        if (closestPlayer != null && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentInit.VETERAN.get()), (ItemStack)closestPlayer.m_6844_(EquipmentSlot.HEAD)) > 0 && (invertedMovementFactor = 1.0 - (movementFactor = Math.sqrt((xDiff = (closestPlayer.m_20185_() - xpEntity.m_20185_()) / range) * xDiff + (yDiff = (closestPlayer.m_20186_() + (double)closestPlayer.m_20192_() - xpEntity.m_20186_()) / range) * yDiff + (zDiff = (closestPlayer.m_20189_() - xpEntity.m_20189_()) / range) * zDiff))) > 0.0) {
            invertedMovementFactor *= invertedMovementFactor;
            Vec3 motion = xpEntity.m_20184_();
            xpEntity.m_20334_(motion.f_82479_ + xDiff / movementFactor * invertedMovementFactor * 0.3, motion.f_82480_ + yDiff / movementFactor * invertedMovementFactor * 0.3, motion.f_82481_ + zDiff / movementFactor * invertedMovementFactor * 0.3);
        }
    }

    public int m_6183_(int enchantmentLevel) {
        return 10;
    }

    public int m_6175_(int enchantmentLevel) {
        return 40;
    }

    public int m_6586_() {
        return (Boolean)EnchantmentInit.enableVeteran.get() != false ? 1 : 0;
    }

    public boolean m_6081_(ItemStack stack) {
        ArmorItem armorItem;
        Item item = stack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_().equals((Object)EquipmentSlot.HEAD) && (Boolean)EnchantmentInit.enableVeteran.get() != false;
    }

    public boolean m_6592_() {
        return (Boolean)EnchantmentInit.enableVeteran.get();
    }

    public boolean m_6591_() {
        return (Boolean)EnchantmentInit.veteranTreasureOnly.get();
    }

    public boolean m_6594_() {
        return (Boolean)EnchantmentInit.enableVeteran.get();
    }
}

