/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.misc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class Utils {
    public static FakePlayer getFakePlayer(Level level) {
        Level level2 = level;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            return FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
        }
        return null;
    }

    private static double max5(double a, double b, double c, double d, double e) {
        return Math.max(Math.max(Math.max(Math.max(a, b), c), d), e);
    }

    private static double min5(double a, double b, double c, double d, double e) {
        return Math.min(Math.min(Math.min(Math.min(a, b), c), d), e);
    }

    private static Vec3 getVectorFromRPY(double length, double y, double p, double r) {
        y = Math.toRadians(y + 90.0);
        p = Math.toRadians(180.0 - p);
        r = Math.toRadians(r + 180.0);
        double y2 = y + Math.toRadians(90.0);
        double ll = length * Math.cos(r);
        double ss = length * Math.sin(r);
        double xz = ll * Math.cos(p);
        double yy = ll * Math.sin(p);
        double xl = xz * Math.cos(y);
        double zl = xz * Math.sin(y);
        double xs = ss * Math.cos(y2);
        double zs = ss * Math.sin(y2);
        double xx = xl + xs;
        double zz = zl + zs;
        return new Vec3(xx, yy, zz);
    }

    public static AABB getConeBoundApprox(LivingEntity livingEntity, int enchantmentLvl) {
        double length = Math.pow(2.0, (double)enchantmentLvl - 1.0) * 16.0;
        float radius = 2.0f;
        float hyp = (float)Math.sqrt((double)(radius * radius) + length * length);
        Vec3 p0 = livingEntity.m_20299_(1.0f);
        float y = livingEntity.m_146908_();
        float p = livingEntity.m_146909_();
        float f = (float)Math.toDegrees(Math.atan2(radius, length));
        Vec3 v0 = Utils.getVectorFromRPY(hyp, y, p, 0.0f - f);
        Vec3 v1 = Utils.getVectorFromRPY(hyp, y, p, 0.0f + f);
        Vec3 v2 = Utils.getVectorFromRPY(hyp, y, p - f, 0.0);
        Vec3 v3 = Utils.getVectorFromRPY(hyp, y, p + f, 0.0);
        Vec3 q0 = p0.m_82549_(v0);
        Vec3 q1 = p0.m_82549_(v1);
        Vec3 q2 = p0.m_82549_(v2);
        Vec3 q3 = p0.m_82549_(v3);
        float mx = (float)Utils.max5(p0.f_82479_, q0.f_82479_, q1.f_82479_, q2.f_82479_, q3.f_82479_);
        float nx = (float)Utils.min5(p0.f_82479_, q0.f_82479_, q1.f_82479_, q2.f_82479_, q3.f_82479_);
        float my = (float)Utils.max5(p0.f_82480_, q0.f_82480_, q1.f_82480_, q2.f_82480_, q3.f_82480_);
        float ny = (float)Utils.min5(p0.f_82480_, q0.f_82480_, q1.f_82480_, q2.f_82480_, q3.f_82480_);
        float mz = (float)Utils.max5(p0.f_82481_, q0.f_82481_, q1.f_82481_, q2.f_82481_, q3.f_82481_);
        float nz = (float)Utils.min5(p0.f_82481_, q0.f_82481_, q1.f_82481_, q2.f_82481_, q3.f_82481_);
        return new AABB((double)mx, (double)my, (double)mz, (double)nx, (double)ny, (double)nz);
    }
}

