/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArmorStandSwap
extends Feature {
    private ForgeConfigSpec.BooleanValue enableArmorStandSwapping;

    private static void swapSlot(Player player, ArmorStand armorStand, EquipmentSlot slot) {
        ItemStack playerItem = player.m_6844_(slot);
        ItemStack armorStandItem = armorStand.m_6844_(slot);
        player.m_8061_(slot, armorStandItem);
        armorStand.m_8061_(slot, playerItem);
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableArmorStandSwapping = builder.translation("config.vanillatweaks:enableArmorStandSwapping").comment("Want an way to swap armor with armor stand?").define("enableArmorStandSwapping", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        EquipmentSlot[] equipmentSlotArray;
        Player player = event.getPlayer();
        if (player.m_6047_() && ((Boolean)this.enableArmorStandSwapping.get()).booleanValue() && !player.f_19853_.m_5776_() && !player.m_5833_() && (equipmentSlotArray = event.getTarget()) instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)equipmentSlotArray;
            event.setCanceled(true);
            for (EquipmentSlot equipmentSlotType : EquipmentSlot.values()) {
                if (equipmentSlotType.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ArmorStandSwap.swapSlot(player, armorStand, equipmentSlotType);
            }
        }
    }
}

