/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BeehiveTooltips
extends Feature {
    private ForgeConfigSpec.BooleanValue enableBeehiveTooltips;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableBeehiveTooltips = builder.translation("config.vanillatweaks:enableBeehiveTooltips").comment("Want to see the no of bees or the honey level of an beehive?").define("enableBeehiveTooltips", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onToolTipEvent(ItemTooltipEvent event) {
        BlockItem blockItem;
        Item item;
        if (event.getFlags().m_7050_() && ((Boolean)this.enableBeehiveTooltips.get()).booleanValue() && (item = event.getItemStack().m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof BeehiveBlock) {
            CompoundTag tag = event.getItemStack().m_41784_();
            CompoundTag beTag = tag.m_128469_("BlockEntityTag");
            ListTag bees = beTag.m_128437_("Bees", 10);
            CompoundTag blockStateTag = tag.m_128469_("BlockStateTag");
            String honeyLvl = blockStateTag.m_128461_("honey_level");
            event.getToolTip().add(new TranslatableComponent("vanillatweaks.bees").m_7220_((Component)new TextComponent(String.format("%d", bees.size()))));
            event.getToolTip().add(new TranslatableComponent("vanillatweaks.honey.lvl").m_7220_((Component)new TextComponent(String.format("%s", honeyLvl))));
        }
    }
}

