/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobsBurnInDaylight
extends Feature {
    private ForgeConfigSpec.BooleanValue babyZombieBurnInDaylight;
    private ForgeConfigSpec.BooleanValue creeperBurnInDaylight;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.babyZombieBurnInDaylight = builder.translation("config.vanillatweaks:babyZombieBurnInDaylight").comment("Want baby zombies to burn by the light of the day?").define("babyZombieBurnInDaylight", true);
        this.creeperBurnInDaylight = builder.translation("config.vanillatweaks:creeperBurnInDaylight").comment("Want creeper's to burn in daylight?").define("creeperBurnInDaylight", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        boolean flag;
        LivingEntity entity = event.getEntityLiving();
        if ((entity instanceof Creeper && ((Boolean)this.creeperBurnInDaylight.get()).booleanValue() || entity instanceof Zombie && entity.m_6162_() && ((Boolean)this.babyZombieBurnInDaylight.get()).booleanValue()) && (flag = this.canBurn(entity))) {
            ItemStack itemstack = entity.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41773_() + entity.m_21187_().nextInt(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        entity.m_21166_(EquipmentSlot.HEAD);
                        entity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                entity.m_20254_(8);
            }
        }
    }

    boolean canBurn(LivingEntity entity) {
        Level level = entity.f_19853_;
        if (level.m_46461_() && !level.f_46443_) {
            float f = entity.m_6073_();
            boolean flag = entity.m_20071_() || entity.f_146808_ || entity.f_146809_;
            return f > 0.5f && entity.m_21187_().nextFloat() * 30.0f < (f - 0.4f) * 2.0f && !flag && level.m_45527_(entity.m_142538_());
        }
        return false;
    }
}

