/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Sickle
extends Feature {
    private ForgeConfigSpec.BooleanValue hoeActsAsSickle;

    private static boolean canHarvest(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof BushBlock && !(block instanceof WaterlilyBlock) || block instanceof SugarCaneBlock;
    }

    private int getRange(Item item) {
        if (item == Items.f_42392_) {
            return 2;
        }
        if (item == Items.f_42397_) {
            return 3;
        }
        return 1;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.hoeActsAsSickle = builder.translation("config.vanillatweaks:hoeActsAsSickle").comment("Want hoe to act like a sickle?").define("hoeActsAsSickle", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        ItemStack stack = player.m_21211_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof HoeItem && Sickle.canHarvest(event.getState()) && ((Boolean)this.hoeActsAsSickle.get()).booleanValue()) {
            int range = this.getRange(stack.m_41720_());
            for (int i = -range; i < range + 1; ++i) {
                for (int k = -range; k < range + 1; ++k) {
                    BlockPos pos;
                    BlockState state;
                    if (i == 0 && k == 0 || !Sickle.canHarvest(state = world.m_8055_(pos = event.getPos().m_142082_(i, 0, k)))) continue;
                    Block block = state.m_60734_();
                    if (block.canHarvestBlock(state, (BlockGetter)world, pos, player)) {
                        block.m_6240_(world, player, pos, state, world.m_7702_(pos), stack);
                    }
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    world.m_5594_(player, player.m_142538_(), state.getSoundType((LevelReader)world, pos, (Entity)player).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(playerEntity.m_7655_()));
        }
    }
}

