/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks.silkspawner;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.tweaks.silkspawner.DummySpawnerLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SilkSpawner
extends Feature {
    private static final String SPAWNER_TAG = "SilkSpawnerData";
    private ForgeConfigSpec.BooleanValue enableSilkSpawner;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableSilkSpawner = builder.translation("config.vanillatweaks:enableSilkSpawner").comment("Want the ability to move spawners with silk touch?").define("enableSilkSpawner", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            BlockEntity tile;
            BlockEntity blockEntity;
            CompoundTag spawnerDataNBT;
            Player player = (Player)entity;
            ItemStack stack = player.m_21120_(player.m_7655_());
            if (((Boolean)this.enableSilkSpawner.get()).booleanValue() && !stack.m_41619_() && stack.m_41782_() && stack.m_41720_() == Items.f_42007_ && !(spawnerDataNBT = stack.m_41784_().m_128469_(SPAWNER_TAG)).m_128456_() && (blockEntity = (tile = event.getWorld().m_7702_(event.getPos()))) instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                spawnerBlockEntity.m_59801_().m_151328_(player.f_19853_, event.getPos(), spawnerDataNBT);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreak(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().f_19853_;
        BlockEntity blockEntity = level.m_7702_(event.getPos());
        int lvl = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)event.getPlayer().m_21205_());
        if (event.getState().m_60734_() instanceof SpawnerBlock && !level.m_5776_() && blockEntity instanceof SpawnerBlockEntity && ((Boolean)this.enableSilkSpawner.get()).booleanValue() && lvl >= 1) {
            event.setExpToDrop(0);
            ItemStack drop = new ItemStack((ItemLike)Blocks.f_50085_);
            CompoundTag spawnerData = ((SpawnerBlockEntity)blockEntity).m_59801_().m_151339_(blockEntity.m_58904_(), event.getPos(), new CompoundTag());
            CompoundTag stackTag = new CompoundTag();
            spawnerData.m_128473_("Delay");
            stackTag.m_128365_(SPAWNER_TAG, (Tag)spawnerData);
            drop.m_41751_(stackTag);
            Block.m_49840_((Level)event.getPlayer().f_19853_, (BlockPos)event.getPos(), (ItemStack)drop);
            level.m_46747_(blockEntity.m_58899_());
            level.m_46961_(event.getPos(), false);
            event.setCanceled(true);
        }
    }

    @Mod.EventBusSubscriber(modid="vanillatweaks", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onToolTipEvent(ItemTooltipEvent event) {
            CompoundTag spawnerDataNBT;
            ItemStack stack = event.getItemStack();
            if (stack.m_41782_() && !(spawnerDataNBT = stack.m_41784_().m_128469_(SilkSpawner.SPAWNER_TAG)).m_128456_()) {
                DummySpawnerLogic.DUMMY_SPAWNER_LOGIC.m_151328_(event.getEntity().f_19853_, BlockPos.f_121853_, spawnerDataNBT);
                Entity ent = DummySpawnerLogic.DUMMY_SPAWNER_LOGIC.m_151314_(event.getEntity().f_19853_);
                if (ent != null) {
                    event.getToolTip().add(ent.m_5446_());
                }
            }
        }
    }
}

