/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.strikerrocker.vt.base.Feature;
import java.util.Optional;
import net.minecraft.data.worldgen.Features;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NoMoreLavaPocketGen
extends Feature {
    private ForgeConfigSpec.BooleanValue disableLavaPocketGen;

    private static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> configuredFeature1, ConfiguredFeature<?, ?> configuredFeature2) {
        Optional configuredFeatureJSON1 = ConfiguredFeature.f_65373_.encode(configuredFeature1, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        Optional configuredFeatureJSON2 = ConfiguredFeature.f_65373_.encode(configuredFeature2, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (configuredFeatureJSON1.isEmpty() || configuredFeatureJSON2.isEmpty()) {
            return false;
        }
        return configuredFeatureJSON1.equals(configuredFeatureJSON2);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.disableLavaPocketGen = builder.translation("config.vanillatweaks:disableLavaPocketGen").comment("Don't want that that pesky lava pockets in nether to kill you?").define("disableLavaPocketGen", true);
    }

    @SubscribeEvent
    public void biomeCreationEvent(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.BiomeCategory.NETHER && ((Boolean)this.disableLavaPocketGen.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).removeIf(configuredFeatureSupplier -> NoMoreLavaPocketGen.serializeAndCompareFeature(Features.f_126916_, (ConfiguredFeature)configuredFeatureSupplier.get()) || NoMoreLavaPocketGen.serializeAndCompareFeature(Features.f_126917_, (ConfiguredFeature)configuredFeatureSupplier.get()));
        }
    }
}

