/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.misc.ConeShape;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5134;
import net.minecraft.class_6025;

public class EnchantmentImpl {
    private static final UUID vigorUUID = UUID.fromString("18339f34-6ab5-461d-a103-9b9a3ac3eec7");
    private static final UUID nimbleUUID = UUID.fromString("05b61a62-ae84-492e-8536-f365b7143296");

    public static void triggerVigor(class_1309 livingEntity, class_1887 vigor) {
        int lvl = class_1890.method_8225((class_1887)vigor, (class_1799)livingEntity.method_6118(class_1304.field_6174));
        class_1324 vigorAttribute = livingEntity.method_5996(class_5134.field_23716);
        class_1322 vigorModifier = new class_1322(vigorUUID, "vigor", (double)((float)lvl / 10.0f), class_1322.class_1323.field_6330);
        if (vigorAttribute != null) {
            vigorAttribute.method_6200(vigorUUID);
            if (lvl > 0) {
                vigorAttribute.method_26837(vigorModifier);
            }
            if (livingEntity.method_6032() > livingEntity.method_6063()) {
                livingEntity.method_6033(livingEntity.method_6063());
            }
        }
    }

    public static void moveXP(class_1297 entity, class_1887 enchantment) {
        double zDiff;
        double yDiff;
        double xDiff;
        double movementFactor;
        double invertedMovementFactor;
        double range = 32.0;
        class_1657 closestPlayer = entity.method_37908().method_18460(entity, range);
        if (closestPlayer != null && class_1890.method_8225((class_1887)enchantment, (class_1799)closestPlayer.method_6118(class_1304.field_6169)) > 0 && (invertedMovementFactor = 1.0 - (movementFactor = Math.sqrt((xDiff = (closestPlayer.method_19538().method_10216() - entity.method_19538().method_10216()) / range) * xDiff + (yDiff = (closestPlayer.method_19538().method_10214() + (double)closestPlayer.method_5751() - entity.method_19538().method_10214()) / range) * yDiff + (zDiff = (closestPlayer.method_19538().method_10215() - entity.method_19538().method_10215()) / range) * zDiff))) > 0.0) {
            invertedMovementFactor *= invertedMovementFactor;
            class_243 motion = entity.method_18798();
            entity.method_18800(motion.field_1352 + xDiff / movementFactor * invertedMovementFactor * 0.3, motion.field_1351 + yDiff / movementFactor * invertedMovementFactor * 0.3, motion.field_1350 + zDiff / movementFactor * invertedMovementFactor * 0.3);
        }
    }

    public static void triggerNimble(class_1309 livingEntity, class_1887 enchantment) {
        int lvl = class_1890.method_8225((class_1887)enchantment, (class_1799)livingEntity.method_6118(class_1304.field_6166));
        class_1324 speedAttribute = livingEntity.method_5996(class_5134.field_23719);
        class_1322 speedModifier = new class_1322(nimbleUUID, "Nimble", (double)lvl * (double)0.2f, class_1322.class_1323.field_6331);
        if (speedAttribute != null) {
            speedAttribute.method_6200(nimbleUUID);
            if (lvl > 0) {
                speedAttribute.method_26837(speedModifier);
            }
        }
    }

    public static void triggerHops(class_1309 livingEntity, class_1887 enchantment) {
        int lvl = class_1890.method_8225((class_1887)enchantment, (class_1799)livingEntity.method_6118(class_1304.field_6166));
        if (lvl > 0) {
            if (!livingEntity.method_6059(class_1294.field_5913)) {
                livingEntity.method_6092(new class_1293(class_1294.field_5913, Integer.MAX_VALUE, lvl, true, false, false));
            }
        } else if (livingEntity.method_6059(class_1294.field_5913)) {
            livingEntity.method_6016(class_1294.field_5913);
        }
    }

    public static class_1309 getHomingTarget(class_1937 world, class_1309 shooter, int homingLevel) {
        class_238 coneBound = ConeShape.getConeBoundApprox(shooter, homingLevel);
        List potentialTargets = world.method_8335((class_1297)shooter, coneBound);
        class_1309 target = null;
        for (class_1297 potentialTarget : potentialTargets) {
            class_6025 tamed;
            if (!(potentialTarget instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)potentialTarget;
            if (!shooter.method_6057(potentialTarget) || livingEntity instanceof class_6025 && (tamed = (class_6025)livingEntity).method_6139() == shooter.method_5667()) continue;
            target = livingEntity;
        }
        if (target != null) {
            VanillaTweaks.LOGGER.debug(coneBound.toString());
            VanillaTweaks.LOGGER.debug(target.toString());
        }
        return target;
    }

    public static void triggerHoming(class_1665 arrow, class_1309 shooter, class_1887 enchantment) {
        class_1309 target;
        int lvl = class_1890.method_8225((class_1887)enchantment, (class_1799)shooter.method_6030());
        if (lvl > 0 && (target = EnchantmentImpl.getHomingTarget(arrow.method_5770(), shooter, lvl)) != null) {
            double x = target.method_23317() - arrow.method_23317();
            double y = target.method_23320() - arrow.method_23318();
            double z = target.method_23321() - arrow.method_23321();
            arrow.method_5875(true);
            arrow.method_7485(x, y, z, (float)arrow.method_18798().method_1033(), 0.0f);
        }
    }

    public static List<class_1799> blazingLogic(class_3218 level, class_1297 entity, class_1799 tool, List<class_1799> dropList) {
        if (tool == null || !(entity instanceof class_1657)) {
            return dropList;
        }
        ArrayList<class_1799> newDropList = new ArrayList<class_1799>();
        dropList.forEach(stack -> newDropList.add(EnchantmentImpl.smelt(stack, level)));
        return newDropList;
    }

    public static class_1799 smelt(class_1799 stack, class_3218 level) {
        return level.method_8433().method_8132(class_3956.field_17546, (class_1263)new class_1277(new class_1799[]{stack}), (class_1937)level).map(smeltingRecipe -> ((class_3861)smeltingRecipe.comp_1933()).method_8110(level.method_30349())).filter(itemStack -> !itemStack.method_7960()).map(itemStack -> {
            class_1799 copy = itemStack.method_7972();
            copy.method_7939(stack.method_7947() * itemStack.method_7947());
            return copy;
        }).orElse(stack);
    }

    public static List<class_1799> siphonLogic(class_1297 entity, List<class_1799> dropList) {
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            ArrayList<class_1799> newDropList = new ArrayList<class_1799>(dropList);
            newDropList.removeIf(arg_0 -> ((class_1657)playerEntity).method_7270(arg_0));
            return newDropList;
        }
        return dropList;
    }
}

