/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.base;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.ForgeFeature;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public abstract class ForgeModule {
    private final Map<String, ForgeFeature> features = new HashMap<String, ForgeFeature>();
    private final ForgeConfigSpec.Builder configBuilder;
    private final String name;
    private final String comments;

    protected ForgeModule(String name, String comments, ForgeConfigSpec.Builder configBuilder) {
        this.name = name;
        this.comments = comments;
        this.configBuilder = configBuilder;
        this.addFeatures();
    }

    public abstract void addFeatures();

    public void setup(FMLCommonSetupEvent event) {
        this.features.values().stream().filter(ForgeFeature::usesEvents).forEach(feature -> {
            MinecraftForge.EVENT_BUS.register(feature);
            VanillaTweaks.LOGGER.debug("Registered Event Handler for class {}", (Object)feature.getClass().getName());
        });
        this.features.values().forEach(feature -> feature.setup(event));
    }

    public void setupConfig() {
        this.configBuilder.comment(this.comments).push(this.name);
        this.features.values().forEach(feature -> feature.setupConfig(this.configBuilder));
        this.configBuilder.pop();
    }

    protected void registerFeature(String name, ForgeFeature feature) {
        this.features.put(name, feature);
    }
}

