/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.misc.ConeShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnchantmentImpl {
    private static final UUID vigorUUID = UUID.fromString("18339f34-6ab5-461d-a103-9b9a3ac3eec7");
    private static final UUID nimbleUUID = UUID.fromString("05b61a62-ae84-492e-8536-f365b7143296");

    public static void triggerVigor(LivingEntity livingEntity, Enchantment vigor) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)vigor, (ItemStack)livingEntity.m_6844_(EquipmentSlot.CHEST));
        AttributeInstance vigorAttribute = livingEntity.m_21051_(Attributes.f_22276_);
        AttributeModifier vigorModifier = new AttributeModifier(vigorUUID, "vigor", (double)((float)lvl / 10.0f), AttributeModifier.Operation.MULTIPLY_BASE);
        if (vigorAttribute != null) {
            if (lvl > 0) {
                if (vigorAttribute.m_22111_(vigorUUID) == null) {
                    vigorAttribute.m_22125_(vigorModifier);
                }
            } else if (vigorAttribute.m_22111_(vigorUUID) != null) {
                vigorAttribute.m_22130_(vigorModifier);
                if (livingEntity.m_21223_() > livingEntity.m_21233_()) {
                    livingEntity.m_21153_(livingEntity.m_21233_());
                }
            }
        }
    }

    public static void moveXP(Entity entity, Enchantment enchantment) {
        double zDiff;
        double yDiff;
        double xDiff;
        double movementFactor;
        double invertedMovementFactor;
        double range = 32.0;
        Player closestPlayer = entity.f_19853_.m_45930_(entity, range);
        if (closestPlayer != null && EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)closestPlayer.m_6844_(EquipmentSlot.HEAD)) > 0 && (invertedMovementFactor = 1.0 - (movementFactor = Math.sqrt((xDiff = (closestPlayer.m_20182_().m_7096_() - entity.m_20182_().m_7096_()) / range) * xDiff + (yDiff = (closestPlayer.m_20182_().m_7098_() + (double)closestPlayer.m_20192_() - entity.m_20182_().m_7098_()) / range) * yDiff + (zDiff = (closestPlayer.m_20182_().m_7094_() - entity.m_20182_().m_7094_()) / range) * zDiff))) > 0.0) {
            invertedMovementFactor *= invertedMovementFactor;
            Vec3 motion = entity.m_20184_();
            entity.m_20334_(motion.f_82479_ + xDiff / movementFactor * invertedMovementFactor * 0.3, motion.f_82480_ + yDiff / movementFactor * invertedMovementFactor * 0.3, motion.f_82481_ + zDiff / movementFactor * invertedMovementFactor * 0.3);
        }
    }

    public static void triggerNimble(LivingEntity livingEntity, Enchantment enchantment) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)livingEntity.m_6844_(EquipmentSlot.FEET));
        AttributeInstance speedAttribute = livingEntity.m_21051_(Attributes.f_22279_);
        AttributeModifier speedModifier = new AttributeModifier(nimbleUUID, "Nimble", (double)lvl * (double)0.2f, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (speedAttribute != null) {
            if (lvl > 0) {
                if (speedAttribute.m_22111_(nimbleUUID) == null) {
                    speedAttribute.m_22125_(speedModifier);
                }
            } else if (speedAttribute.m_22111_(nimbleUUID) != null) {
                speedAttribute.m_22130_(speedModifier);
            }
        }
    }

    public static void triggerHops(LivingEntity livingEntity, Enchantment enchantment) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)livingEntity.m_6844_(EquipmentSlot.FEET));
        if (lvl > 0) {
            if (!livingEntity.m_21023_(MobEffects.f_19603_)) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Integer.MAX_VALUE, lvl, true, false, false));
            }
        } else if (livingEntity.m_21023_(MobEffects.f_19603_)) {
            livingEntity.m_21195_(MobEffects.f_19603_);
        }
    }

    public static LivingEntity getHomingTarget(Level world, LivingEntity shooter, int homingLevel) {
        AABB coneBound = ConeShape.getConeBoundApprox(shooter, homingLevel);
        List potentialTargets = world.m_45933_((Entity)shooter, coneBound);
        LivingEntity target = null;
        for (Entity potentialTarget : potentialTargets) {
            OwnableEntity tamed;
            if (!(potentialTarget instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)potentialTarget;
            if (!shooter.m_142582_(potentialTarget) || livingEntity instanceof OwnableEntity && (tamed = (OwnableEntity)livingEntity).m_142504_() == shooter.m_142081_()) continue;
            target = livingEntity;
        }
        VanillaTweaks.LOGGER.debug((Object)coneBound);
        VanillaTweaks.LOGGER.debug(target);
        return target;
    }

    public static void triggerHoming(AbstractArrow arrow, LivingEntity shooter, Enchantment enchantment) {
        LivingEntity target;
        int lvl = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)shooter.m_21211_());
        if (lvl > 0 && (target = EnchantmentImpl.getHomingTarget(arrow.m_20193_(), shooter, lvl)) != null) {
            double x = target.m_20185_() - arrow.m_20185_();
            double y = target.m_20188_() - arrow.m_20186_();
            double z = target.m_20189_() - arrow.m_20189_();
            arrow.m_20242_(true);
            arrow.m_6686_(x, y, z, (float)arrow.m_20184_().m_82553_(), 0.0f);
        }
    }

    public static List<ItemStack> blazingLogic(ServerLevel world, Entity entity, ItemStack tool, List<ItemStack> dropList) {
        RecipeManager recipeManager = world.m_7465_();
        SimpleContainer simpleInv = new SimpleContainer(1);
        ArrayList<ItemStack> newDropList = new ArrayList<ItemStack>(dropList);
        if (!newDropList.isEmpty()) {
            for (int i = 0; i < newDropList.size(); ++i) {
                ItemStack itemToBeChecked = newDropList.get(i);
                simpleInv.m_6836_(0, itemToBeChecked);
                Optional smeltingResult = recipeManager.m_44015_(RecipeType.f_44108_, (Container)simpleInv, entity.f_19853_);
                if (!smeltingResult.isPresent() || !(entity instanceof Player)) continue;
                Player playerEntity = (Player)entity;
                int count = itemToBeChecked.m_41613_();
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool) > 0) {
                    count = EnchantmentImpl.getFortuneCount(world.m_5822_(), count, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool));
                    tool.m_41622_(Math.max(count - 1, 3), (LivingEntity)playerEntity, player -> player.m_21190_(player.m_7655_()));
                }
                newDropList.set(i, new ItemStack((ItemLike)((SmeltingRecipe)smeltingResult.get()).m_8043_().m_41720_(), count));
                playerEntity.m_6756_((int)(((SmeltingRecipe)smeltingResult.get()).m_43750_() * (float)itemToBeChecked.m_41613_()));
            }
        }
        return newDropList;
    }

    public static int getFortuneCount(Random random, int initialCount, int lvl) {
        if (lvl > 0) {
            int i = random.nextInt(lvl + 2) - 1;
            if (i < 0) {
                i = 0;
            }
            return initialCount * (i + 1);
        }
        return initialCount;
    }

    public static List<ItemStack> siphonLogic(Entity entity, List<ItemStack> dropList) {
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            ArrayList<ItemStack> newDropList = new ArrayList<ItemStack>(dropList);
            newDropList.removeIf(arg_0 -> ((Player)playerEntity).m_36356_(arg_0));
            return newDropList;
        }
        return dropList;
    }
}

