/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.ForgeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArrowSetFire
extends ForgeFeature {
    private ForgeConfigSpec.BooleanValue arrowsSetBlockOnFire;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.arrowsSetBlockOnFire = builder.translation("config.vanillatweaks:arrowsSetBlockOnFire").comment("Want the fire arrows to set fire on block it landed?").define("arrowsSetBlockOnFire", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onArrowImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            if (((Boolean)this.arrowsSetBlockOnFire.get()).booleanValue() && !arrow.f_19853_.m_5776_() && arrow.m_6060_()) {
                BlockPos pos = arrow.m_142538_();
                Vec3 vec3d = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82549_(arrow.m_20184_());
                BlockHitResult blockHitResult = arrow.f_19853_.m_45547_(new ClipContext(arrow.m_20182_(), vec3d, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
                BlockPos pos1 = pos.m_142300_(blockHitResult.m_82434_());
                if (arrow.f_19853_.m_8055_(pos1).m_60795_()) {
                    arrow.f_19853_.m_7731_(pos1, BaseFireBlock.m_49245_((BlockGetter)arrow.f_19853_, (BlockPos)pos1), 11);
                }
            }
        }
    }
}

