/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.strikerrocker.vt.base.ForgeFeature;
import java.util.Optional;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NoMoreLavaPocketGen
extends ForgeFeature {
    private ForgeConfigSpec.BooleanValue disableLavaPocketGen;

    private static boolean compareFeature(PlacedFeature placedFeature1, PlacedFeature placedFeature2) {
        Optional placedFeatureJSON1 = PlacedFeature.f_191772_.encode((Object)placedFeature1, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        Optional placedFeatureJSON2 = PlacedFeature.f_191772_.encode((Object)placedFeature2, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (placedFeatureJSON1.isEmpty() || placedFeatureJSON2.isEmpty()) {
            return false;
        }
        return placedFeatureJSON1.equals(placedFeatureJSON2);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.disableLavaPocketGen = builder.translation("config.vanillatweaks:disableLavaPocketGen").comment("Don't want that that pesky lava pockets in nether to kill you?").define("disableLavaPocketGen", true);
    }

    @SubscribeEvent
    public void biomesLoadingEvent(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.BiomeCategory.NETHER && ((Boolean)this.disableLavaPocketGen.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).removeIf(featureSupplier -> {
                PlacedFeature feature = (PlacedFeature)featureSupplier.get();
                return NoMoreLavaPocketGen.compareFeature(NetherPlacements.f_195294_, feature) || NoMoreLavaPocketGen.compareFeature(NetherPlacements.f_195295_, feature) || NoMoreLavaPocketGen.compareFeature(NetherPlacements.f_195296_, feature);
            });
        }
    }
}

