/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.blocks;

import io.github.strikerrocker.vt.base.ForgeFeature;
import io.github.strikerrocker.vt.content.CommonBlocks;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalBlock;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalBlockEntity;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalContainer;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalRenderer;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBlocks
extends ForgeFeature {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"vanillatweaks");
    public static final DeferredRegister<MenuType<?>> MENU_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"vanillatweaks");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"vanillatweaks");
    public static final RegistryObject<Block> PEDESTAL_BLOCK = BLOCKS.register("pedestal", PedestalBlock::new);
    public static final RegistryObject<Block> CHARCOAL_BLOCK = BLOCKS.register("charcoal_block", () -> CommonBlocks.CHARCOAL_BLOCK);
    public static final RegistryObject<Block> SUGAR_BLOCK = BLOCKS.register("sugar_block", () -> CommonBlocks.SUGAR_BLOCK);
    public static final RegistryObject<Block> FLINT_BLOCK = BLOCKS.register("flint_block", () -> CommonBlocks.FLINT_BLOCK);
    public static final RegistryObject<MenuType<PedestalContainer>> PEDESTAL_MENU_TYPE = MENU_TYPE.register("pedestal", () -> IForgeMenuType.create((windowId, inv, data) -> new PedestalContainer(windowId, inv, data.m_130135_())));
    static ForgeConfigSpec.BooleanValue enableStorageBlocks;
    static ForgeConfigSpec.BooleanValue enablePedestal;
    public static final RegistryObject<BlockEntityType<PedestalBlockEntity>> PEDESTAL_TYPE;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        enablePedestal = builder.translation("config.vanillatweaks:enablePedestal").comment("Want to showcase your treasure but item frame doesn't satisfy you?").define("enablePedestal", true);
        enableStorageBlocks = builder.translation("config.vanillatweaks:enableStorageBlocks").comment("Want block forms of flint, charcoal and sugar?").define("enableStorageBlocks", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item == ((Block)CHARCOAL_BLOCK.get()).m_5456_()) {
            event.setBurnTime(16000);
        }
        if (item == Blocks.f_50081_.m_5456_()) {
            event.setBurnTime(400);
        }
    }

    static {
        PEDESTAL_TYPE = BLOCK_ENTITY_TYPE.register("pedestal", () -> BlockEntityType.Builder.m_155273_(PedestalBlockEntity::new, (Block[])new Block[]{(Block)PEDESTAL_BLOCK.get()}).m_58966_(null));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            MenuScreens.m_96206_((MenuType)((MenuType)PEDESTAL_MENU_TYPE.get()), PedestalScreen::new);
            event.registerBlockEntityRenderer((BlockEntityType)PEDESTAL_TYPE.get(), PedestalRenderer::new);
        }
    }
}

