/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class TweaksImpl {
    public static final String SPAWNER_TAG = "SilkSpawnerData";

    public static void swapSlot(Player player, ArmorStand armorStand, EquipmentSlot slot) {
        ItemStack playerItem = player.m_6844_(slot);
        ItemStack armorStandItem = armorStand.m_6844_(slot);
        player.m_8061_(slot, armorStandItem);
        armorStand.m_8061_(slot, playerItem);
    }

    public static boolean canBurn(LivingEntity entity) {
        Level world = entity.f_19853_;
        if (world.m_46461_() && !world.f_46443_) {
            float f = entity.m_213856_();
            boolean bl = entity.m_20071_() || entity.f_146808_ || entity.f_146809_;
            return f > 0.5f && entity.m_217043_().m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !bl && world.m_45527_(entity.m_20183_());
        }
        return false;
    }

    public static boolean canHarvest(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof BushBlock && !(block instanceof WaterlilyBlock) || block instanceof SugarCaneBlock;
    }

    public static int getRange(Item item) {
        if (item == Items.f_42392_) {
            return 2;
        }
        if (item == Items.f_42397_) {
            return 3;
        }
        return 1;
    }

    public static void addBeeHiveTooltip(ItemStack stack, List<Component> tooltips) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag beTag = tag.m_128469_("BlockEntityTag");
        ListTag bees = beTag.m_128437_("Bees", 10);
        CompoundTag blockStateTag = tag.m_128469_("BlockStateTag");
        String honeyLvl = blockStateTag.m_128461_("honey_level");
        tooltips.add((Component)Component.m_237115_((String)"vanillatweaks.bees").m_7220_((Component)Component.m_237113_((String)String.format("%d", bees.size()))));
        tooltips.add((Component)Component.m_237115_((String)"vanillatweaks.honey.lvl").m_7220_((Component)Component.m_237113_((String)String.format("%s", honeyLvl))));
    }

    public static void triggerSickle(Player player, ItemStack stack, Level world, BlockPos blockPos, BlockState originalState, boolean config) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof HoeItem && TweaksImpl.canHarvest(originalState) && config) {
            int range = TweaksImpl.getRange(stack.m_41720_());
            for (int i = -range; i < range + 1; ++i) {
                for (int k = -range; k < range + 1; ++k) {
                    BlockPos pos;
                    BlockState state;
                    if (i == 0 && k == 0 || !TweaksImpl.canHarvest(state = world.m_8055_(pos = blockPos.m_7918_(i, 0, k)))) continue;
                    Block block = state.m_60734_();
                    if (player.m_36298_(state)) {
                        block.m_6240_(world, player, pos, state, world.m_7702_(pos), stack);
                    }
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    world.m_5594_(player, player.m_20183_(), block.m_49962_(state).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(playerEntity.m_7655_()));
        }
    }

    public static void triggerShearNametag(Player player, ItemStack stack, Entity target, Level world, boolean config) {
        if (config && !stack.m_41619_() && stack.m_41720_() instanceof ShearsItem && target instanceof LivingEntity && target.m_8077_() && !world.f_46443_) {
            target.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            ItemStack nameTag = new ItemStack((ItemLike)Items.f_42656_).m_41714_(target.m_7770_());
            nameTag.m_41784_().m_128405_("RepairCost", 0);
            target.m_19983_(nameTag);
            target.m_6593_(null);
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(playerEntity.m_7655_()));
        }
    }

    public static void triggerTNTIgnition(Level level, BlockPos pos, BlockState blockState, boolean config) {
        block2: {
            block3: {
                if (level.m_5776_() || !config) break block2;
                if (!(blockState.m_60734_() instanceof TntBlock)) break block3;
                for (Direction f : Direction.values()) {
                    BlockState state = level.m_8055_(pos.m_121945_(f));
                    if (!(state.m_60734_() instanceof MagmaBlock) && state.m_60767_() != Material.f_76307_) continue;
                    TntBlock.m_57433_((Level)level, (BlockPos)pos);
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                }
                break block2;
            }
            if (!(blockState.m_60734_() instanceof MagmaBlock)) break block2;
            for (Direction f : Direction.values()) {
                BlockPos offsetPos = pos.m_121945_(f);
                if (!(level.m_8055_(offsetPos).m_60734_() instanceof TntBlock)) continue;
                TntBlock.m_57433_((Level)level, (BlockPos)offsetPos);
                level.m_7731_(offsetPos, Blocks.f_50016_.m_49966_(), 11);
            }
        }
    }

    public static boolean triggerSignEditing(Level level, Player player, BlockEntity blockEntity, InteractionHand hand, boolean config) {
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            if (!level.m_5776_() && player.m_6047_() && config) {
                sign.m_59746_(true);
                player.m_7739_(sign);
                player.m_6674_(hand);
                return true;
            }
        }
        return false;
    }

    public static boolean triggerArmorStandSwap(Player player, Entity target, boolean config) {
        if (player.m_6047_() && config && !player.f_19853_.m_5776_() && !player.m_5833_() && target instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)target;
            for (EquipmentSlot equipmentSlotType : EquipmentSlot.values()) {
                if (equipmentSlotType.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                TweaksImpl.swapSlot(player, armorStand, equipmentSlotType);
            }
            return true;
        }
        return false;
    }

    public static void triggerMobsBurnInSun(LivingEntity livingEntity, boolean creeperConfig, boolean babyZombieConfig) {
        boolean flag;
        if ((livingEntity instanceof Creeper && creeperConfig || livingEntity instanceof Zombie && livingEntity.m_6162_() && babyZombieConfig) && (flag = TweaksImpl.canBurn(livingEntity))) {
            ItemStack itemStack = livingEntity.m_6844_(EquipmentSlot.HEAD);
            if (!itemStack.m_41619_()) {
                if (itemStack.m_41763_()) {
                    itemStack.m_41721_(itemStack.m_41773_() + livingEntity.m_217043_().m_188503_(2));
                    if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                        livingEntity.m_21166_(EquipmentSlot.HEAD);
                        livingEntity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                livingEntity.m_20254_(8);
            }
        }
    }

    public static boolean triggerItemFrameReverse(Entity target, Player player, boolean config) {
        if (target instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)target;
            if (player.m_6144_() && config) {
                int rotation = frame.m_31823_() - 1;
                if (rotation < 0) {
                    rotation = 7;
                }
                frame.m_31770_(rotation);
                return true;
            }
        }
        return false;
    }

    public static void triggerSpawnerPlacement(Level level, BlockPos pos, ItemStack stack, boolean config) {
        BlockEntity tile;
        CompoundTag spawnerDataNBT;
        if (!level.m_5776_() && config && !stack.m_41619_() && stack.m_41720_() == Items.f_42007_ && !(spawnerDataNBT = stack.m_41784_().m_128469_(SPAWNER_TAG)).m_128456_() && (tile = level.m_7702_(pos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)tile;
            spawner.m_59801_().m_151328_(level, pos, spawnerDataNBT);
        }
    }

    public static boolean triggerSpawnerBreak(Level level, BlockPos pos, BlockState state, Player player, boolean config) {
        BlockEntity blockEntity = level.m_7702_(pos);
        int lvl = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
        if (state.m_60734_() instanceof SpawnerBlock && !level.m_5776_() && blockEntity instanceof SpawnerBlockEntity && config && lvl >= 1) {
            ItemStack drop = new ItemStack((ItemLike)Blocks.f_50085_);
            CompoundTag spawnerData = ((SpawnerBlockEntity)blockEntity).m_59801_().m_186381_(new CompoundTag());
            CompoundTag stackTag = new CompoundTag();
            spawnerData.m_128473_("Delay");
            stackTag.m_128365_(SPAWNER_TAG, (Tag)spawnerData);
            drop.m_41751_(stackTag);
            Block.m_49840_((Level)player.m_20193_(), (BlockPos)pos, (ItemStack)drop);
            level.m_46747_(pos);
            level.m_46961_(pos, false);
            return true;
        }
        return false;
    }
}

