/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world;

import io.github.strikerrocker.vt.base.ForgeFeature;
import io.github.strikerrocker.vt.misc.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SelfPlanting
extends ForgeFeature {
    private ForgeConfigSpec.IntValue despawnTime;
    private ForgeConfigSpec.IntValue chanceToPlant;
    private ForgeConfigSpec.BooleanValue enableSelfPlanting;

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableSelfPlanting = builder.translation("config.vanillatweaks:selfPlanting").comment("Want seeds to auto-plant themselves when broken?").define("selfPlanting", true);
        this.despawnTime = builder.translation("config.vanillatweaks:despawnTime").comment("How long a plant item should take to despawn (and attempt to plant) Default Minecraft is 6000.").defineInRange("despawnTime", 6000, 0, Integer.MAX_VALUE);
        this.chanceToPlant = builder.translation("config.vanillatweaks:chanceToPlant").comment("Percentage chance to plant").defineInRange("chanceToPlant", 100, 0, 100);
    }

    @SubscribeEvent
    public void itemDecay(ItemExpireEvent event) {
        if (!this.plant(event.getEntity())) {
            event.setExtraLife(6000 - event.getEntity().lifespan);
        }
    }

    @SubscribeEvent
    public void itemToss(EntityJoinLevelEvent event) {
        Entity entity;
        if (((Boolean)this.enableSelfPlanting.get()).booleanValue() && !event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            Item item = itemEntity.m_32055_().m_41720_();
            Block block = Block.m_49814_((Item)item);
            if (item instanceof BlockItem && block instanceof IPlantable && !(block instanceof FlowerBlock)) {
                itemEntity.lifespan = (Integer)this.despawnTime.get();
            }
        }
    }

    public boolean plant(ItemEntity entity) {
        Level world = entity.m_20193_();
        ItemStack stack = entity.m_32055_().m_41777_();
        Item item = stack.m_41720_();
        Block block = Block.m_49814_((Item)item);
        BlockPos entityPos = new BlockPos((Vec3i)entity.m_20183_());
        if (((Boolean)this.enableSelfPlanting.get()).booleanValue() && item instanceof BlockItem && block instanceof IPlantable && !(block instanceof FlowerBlock)) {
            if (world.f_46441_.m_188502_() > (Integer)this.chanceToPlant.get()) {
                Vec3 entityVec;
                BlockHitResult rayTraceResult;
                FakePlayer player = Utils.getFakePlayer(world);
                InteractionResult result = item.m_6225_(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, rayTraceResult = entity.f_19853_.m_45547_(new ClipContext((entityVec = new Vec3((double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_())).m_82520_(0.0, 2.0, 0.0), entityVec.m_82520_(0.0, -1.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity))));
                if (result == InteractionResult.SUCCESS || result == InteractionResult.CONSUME) {
                    if (stack.m_41613_() > 0) {
                        stack.m_41774_(1);
                    }
                    return true;
                }
                if (stack.m_41613_() > 0) {
                    world.m_7967_((Entity)new ItemEntity(world, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), stack));
                }
            }
            return false;
        }
        return true;
    }
}

