/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.strikerrocker.vt.enchantments.EnchantmentImpl;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

class BlazingModifier
extends LootModifier {
    public static final Supplier<Codec<BlazingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> BlazingModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, BlazingModifier::new)));

    public BlazingModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> dropList, LootContext context) {
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_165124_(LootContextParams.f_81455_);
        if (tool == null || !(entity instanceof Player)) {
            return dropList;
        }
        ObjectArrayList newDropList = new ObjectArrayList();
        dropList.forEach(stack -> newDropList.add((Object)EnchantmentImpl.smelt(stack, context.m_78952_())));
        return newDropList;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

