/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.ForgeFeature;
import io.github.strikerrocker.vt.tweaks.TweaksClientImpl;
import io.github.strikerrocker.vt.tweaks.TweaksImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SilkSpawner
extends ForgeFeature {
    private ForgeConfigSpec.BooleanValue enableSilkSpawner;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableSilkSpawner = builder.translation("config.vanillatweaks:enableSilkSpawner").comment("Want the ability to move spawners with silk touch?").define("enableSilkSpawner", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.m_21120_(player.m_7655_());
            TweaksImpl.triggerSpawnerPlacement(event.getEntity().m_20193_(), event.getPos(), stack, (Boolean)this.enableSilkSpawner.get());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreak(BlockEvent.BreakEvent event) {
        if (TweaksImpl.triggerSpawnerBreak(event.getPlayer().m_9236_(), event.getPos(), event.getState(), event.getPlayer(), (Boolean)this.enableSilkSpawner.get())) {
            event.setExpToDrop(0);
            event.setCanceled(true);
        }
    }

    @Mod.EventBusSubscriber(modid="vanillatweaks", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onToolTipEvent(ItemTooltipEvent event) {
            TweaksClientImpl.addSilkSpawnerTooltip(event.getItemStack(), event.getToolTip());
        }
    }
}

