/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.strikerrocker.vt.base.ForgeFeature;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class NoMoreLavaPocketGen
extends ForgeFeature {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"vanillatweaks");
    public static final RegistryObject<Codec<RemoveFeaturesBiomeModifier>> REMOVE_FEATURES_BIOME_MODIFIER_TYPE = BIOME_MODIFIER_SERIALIZERS.register("remove_features", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(RemoveFeaturesBiomeModifier::biomes), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(RemoveFeaturesBiomeModifier::features), (App)new ExtraCodecs.EitherCodec(GenerationStep.Decoration.f_224188_.listOf(), GenerationStep.Decoration.f_224188_).xmap(either -> (Set)either.map(Set::copyOf, Set::of), set -> set.size() == 1 ? Either.right((Object)((GenerationStep.Decoration[])set.toArray(GenerationStep.Decoration[]::new))[0]) : Either.left(List.copyOf(set))).optionalFieldOf("steps", EnumSet.allOf(GenerationStep.Decoration.class)).forGetter(RemoveFeaturesBiomeModifier::steps)).apply((Applicative)builder, RemoveFeaturesBiomeModifier::new)));
    private static ForgeConfigSpec.BooleanValue disableLavaPocketGen;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        disableLavaPocketGen = builder.translation("config.vanillatweaks:disableLavaPocketGen").comment("Don't want that that pesky lava pockets in nether to kill you?").define("disableLavaPocketGen", true);
    }

    public record RemoveFeaturesBiomeModifier(HolderSet<Biome> biomes, HolderSet<PlacedFeature> features, Set<GenerationStep.Decoration> steps) implements BiomeModifier
    {
        public static ForgeBiomeModifiers.RemoveFeaturesBiomeModifier allSteps(HolderSet<Biome> biomes, HolderSet<PlacedFeature> features) {
            return new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier(biomes, features, EnumSet.allOf(GenerationStep.Decoration.class));
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (((Boolean)disableLavaPocketGen.get()).booleanValue() && phase == BiomeModifier.Phase.REMOVE && this.biomes.m_203333_(biome)) {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                for (GenerationStep.Decoration step : this.steps) {
                    generationSettings.getFeatures(step).removeIf(arg_0 -> this.features.m_203333_(arg_0));
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)REMOVE_FEATURES_BIOME_MODIFIER_TYPE.get();
        }
    }
}

