/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world;

import io.github.strikerrocker.vt.base.ForgeFeature;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RealisticRelationship
extends ForgeFeature {
    BiPredicate<Entity, Entity> wolfSheep = (source, entity) -> source instanceof Wolf && entity instanceof Sheep;
    BiPredicate<Entity, Entity> foxChicken = (source, entity) -> source instanceof Fox && entity instanceof Chicken;
    BiPredicate<Entity, Entity> ocelotChicken = (source, entity) -> source instanceof Ocelot && entity instanceof Chicken;
    BiPredicate<Entity, Entity> foxRabbit = (source, entity) -> source instanceof Fox && entity instanceof Rabbit;
    BiPredicate<Entity, Entity> wolfRabbit = (source, entity) -> source instanceof Wolf && entity instanceof Rabbit;
    private ForgeConfigSpec.BooleanValue enableRealisticRelationship;

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableRealisticRelationship = builder.translation("config.vanillatweaks:realisticRelationship").comment("Is realistic predator/prey relationships activated?").define("realisticRelationship", true);
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        ArrayList dropsCopy = new ArrayList(event.getDrops());
        for (ItemEntity dropEntity : dropsCopy) {
            ItemStack dropItem = dropEntity.m_32055_();
            if (event.getSource().m_7640_() == null) continue;
            Item drop = dropItem.m_41720_();
            Entity source = event.getSource().m_7640_();
            if (!((Boolean)this.enableRealisticRelationship.get()).booleanValue()) continue;
            if (this.wolfSheep.test(source, (Entity)entity) && (drop == Items.f_42658_ || drop == Items.f_42659_)) {
                event.getDrops().remove(dropEntity);
            }
            if ((this.ocelotChicken.test(source, (Entity)entity) || this.foxChicken.test(source, (Entity)entity)) && (drop == Items.f_42581_ || drop == Items.f_42582_)) {
                event.getDrops().remove(dropEntity);
            }
            if (!this.foxRabbit.test(source, (Entity)entity) && !this.wolfRabbit.test(source, (Entity)entity) || drop != Items.f_42697_ && drop != Items.f_42698_) continue;
            event.getDrops().remove(dropEntity);
        }
    }
}

