/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import com.mojang.serialization.Codec;
import io.github.strikerrocker.vt.base.ForgeFeature;
import io.github.strikerrocker.vt.enchantments.BlazingEnchantment;
import io.github.strikerrocker.vt.enchantments.BlazingModifier;
import io.github.strikerrocker.vt.enchantments.EnchantmentImpl;
import io.github.strikerrocker.vt.enchantments.HomingEnchantment;
import io.github.strikerrocker.vt.enchantments.HopsEnchantment;
import io.github.strikerrocker.vt.enchantments.NimbleEnchantment;
import io.github.strikerrocker.vt.enchantments.SiphonEnchantment;
import io.github.strikerrocker.vt.enchantments.SiphonModifier;
import io.github.strikerrocker.vt.enchantments.VeteranEnchantment;
import io.github.strikerrocker.vt.enchantments.VigorEnchantment;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EnchantmentInit
extends ForgeFeature {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"vanillatweaks");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"vanillatweaks");
    public static final RegistryObject<Codec<BlazingModifier>> BLAZING_MODIFIER = GLM.register("blazing", BlazingModifier.CODEC);
    public static final RegistryObject<Codec<SiphonModifier>> SIPHON_MODIFIER = GLM.register("siphon", SiphonModifier.CODEC);
    public static ForgeConfigSpec.BooleanValue enableHops;
    public static ForgeConfigSpec.BooleanValue enableNimble;
    public static ForgeConfigSpec.BooleanValue enableSiphon;
    public static ForgeConfigSpec.BooleanValue enableVeteran;
    public static ForgeConfigSpec.BooleanValue enableVigor;
    public static ForgeConfigSpec.BooleanValue enableHoming;
    public static ForgeConfigSpec.BooleanValue blazingTreasureOnly;
    public static ForgeConfigSpec.BooleanValue hopsTreasureOnly;
    public static final RegistryObject<Enchantment> HOPS;
    public static ForgeConfigSpec.BooleanValue nimbleTreasureOnly;
    public static final RegistryObject<Enchantment> NIMBLE;
    public static ForgeConfigSpec.BooleanValue siphonTreasureOnly;
    public static final RegistryObject<Enchantment> SIPHON;
    public static ForgeConfigSpec.BooleanValue veteranTreasureOnly;
    public static final RegistryObject<Enchantment> VETERAN;
    public static ForgeConfigSpec.BooleanValue vigorTreasureOnly;
    public static final RegistryObject<Enchantment> VIGOR;
    public static ForgeConfigSpec.BooleanValue enableBlazing;
    public static final RegistryObject<Enchantment> BLAZING;
    public static ForgeConfigSpec.BooleanValue homingTreasureOnly;
    public static final RegistryObject<Enchantment> HOMING;

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent event) {
        if (!event.getEntity().m_20193_().m_5776_()) {
            LivingEntity target;
            LivingEntity player = event.getEntity();
            int homingLvl = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)HOMING.get()), (ItemStack)event.getItem());
            if (homingLvl > 0 && (target = EnchantmentImpl.getHomingTarget(event.getEntity().m_20193_(), player, homingLvl)) != null) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 4, 1, true, false, false));
            }
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (((Boolean)enableNimble.get()).booleanValue()) {
            EnchantmentImpl.triggerNimble(event.getEntity(), (Enchantment)NIMBLE.get());
        }
        if (((Boolean)enableVigor.get()).booleanValue()) {
            EnchantmentImpl.triggerVigor(event.getEntity(), (Enchantment)VIGOR.get());
        }
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        enableBlazing = builder.translation("config.vanillatweaks:enableBlazing").comment("Want to smelt things when you mine them?").define("enableBlazing", true);
        enableHops = builder.translation("config.vanillatweaks:enableHops").comment("Want to jump more than a block high with an enchantment?").define("enableHops", true);
        enableNimble = builder.translation("config.vanillatweaks:enableNimble").comment("Want more speed with an enchantment?").define("enableNimble", true);
        enableSiphon = builder.translation("config.vanillatweaks:enableSiphon").comment("Don't want the zombies stealing your items when you are mining?").define("enableSiphon", true);
        enableVeteran = builder.translation("config.vanillatweaks:enableVeteran").comment("Want all the experience in the nearby area?").define("enableVeteran", true);
        enableVigor = builder.translation("config.vanillatweaks:enableVigor").comment("Want more health with an enchant?").define("enableVigor", true);
        enableHoming = builder.translation("config.vanillatweaks:enableHoming").comment("Don't want to aim but love shooting arrows?").define("enableHoming", true);
        blazingTreasureOnly = builder.comment("Want blazing enchantment to only appear in loot?").define("blazingTreasureOnly", false);
        hopsTreasureOnly = builder.comment("Want Hops enchantment to only appear in loot?").define("hopsTreasureOnly", false);
        nimbleTreasureOnly = builder.comment("Want Nimble enchantment to only appear in loot?").define("nimbleTreasureOnly", false);
        siphonTreasureOnly = builder.comment("Want Siphon enchantment to only appear in loot?").define("siphonTreasureOnly", false);
        veteranTreasureOnly = builder.comment("Want Veteran enchantment to only appear in loot?").define("veteranTreasureOnly", false);
        vigorTreasureOnly = builder.comment("Want Vigor enchantment to only appear in loot?").define("vigorTreasureOnly", false);
        homingTreasureOnly = builder.comment("Want Homing enchantment to only appear in loot?").define("homingTreasureOnly", false);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void entityJoin(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        Entity entity;
        if (!event.getLevel().m_5776_() && ((Boolean)enableHoming.get()).booleanValue() && (entity = event.getEntity()) instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)entity;
            EnchantmentImpl.triggerHoming(arrow, shooter, (Enchantment)HOMING.get());
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (((Boolean)enableHops.get()).booleanValue() && !event.getEntity().f_19853_.m_5776_()) {
            EnchantmentImpl.triggerHops(event.getEntity(), (Enchantment)HOPS.get());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent event) {
        if (((Boolean)enableVeteran.get()).booleanValue() && event.level != null && !event.level.m_5776_()) {
            ServerLevel world = (ServerLevel)event.level;
            world.m_143280_((EntityTypeTest)EntityType.f_20570_, EntitySelector.f_20402_).forEach(experienceOrb -> EnchantmentImpl.moveXP((Entity)experienceOrb, (Enchantment)VETERAN.get()));
        }
    }

    static {
        HOPS = ENCHANTMENTS.register("hops", () -> new HopsEnchantment(() -> (Boolean)enableHops.get(), () -> (Boolean)hopsTreasureOnly.get()));
        NIMBLE = ENCHANTMENTS.register("nimble", () -> new NimbleEnchantment(() -> (Boolean)enableNimble.get(), () -> (Boolean)nimbleTreasureOnly.get()));
        SIPHON = ENCHANTMENTS.register("siphon", () -> new SiphonEnchantment(() -> (Boolean)enableSiphon.get(), () -> (Boolean)siphonTreasureOnly.get()));
        VETERAN = ENCHANTMENTS.register("veteran", () -> new VeteranEnchantment(() -> (Boolean)enableVeteran.get(), () -> (Boolean)veteranTreasureOnly.get()));
        VIGOR = ENCHANTMENTS.register("vigor", () -> new VigorEnchantment(() -> (Boolean)enableVigor.get(), () -> (Boolean)vigorTreasureOnly.get()));
        BLAZING = ENCHANTMENTS.register("blazing", () -> new BlazingEnchantment(() -> (Boolean)enableBlazing.get(), () -> (Boolean)blazingTreasureOnly.get()));
        HOMING = ENCHANTMENTS.register("homing", () -> new HomingEnchantment(() -> (Boolean)enableHoming.get(), () -> (Boolean)homingTreasureOnly.get()));
    }
}

