/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.blocks;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.content.blocks.BlockBark;
import io.github.strikerrocker.vt.content.blocks.BlockCharcoal;
import io.github.strikerrocker.vt.content.blocks.BlockSugar;
import io.github.strikerrocker.vt.content.blocks.pedestal.BlockPedestal;
import io.github.strikerrocker.vt.content.blocks.pedestal.PacketUpdatePedestal;
import io.github.strikerrocker.vt.content.blocks.pedestal.TESRPedestal;
import io.github.strikerrocker.vt.content.blocks.pedestal.TileEntityPedestal;
import io.github.strikerrocker.vt.misc.Utils;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Blocks
extends Feature {
    public static final Block pedestal = new BlockPedestal();
    private static final BlockCharcoal charcoal = new BlockCharcoal("charcoalblock");
    private static final BlockBark acaciaBark = new BlockBark("acaciabark", BlockPlanks.EnumType.ACACIA.func_181070_c());
    private static final BlockBark darkOakBark = new BlockBark("darkoakbark", BlockPlanks.EnumType.DARK_OAK.func_181070_c());
    private static final BlockBark oakBark = new BlockBark("oakbark", BlockPlanks.EnumType.OAK.func_181070_c());
    private static final BlockBark spruceBark = new BlockBark("sprucebark", BlockPlanks.EnumType.SPRUCE.func_181070_c());
    private static final BlockBark jungleBark = new BlockBark("junglebark", BlockPlanks.EnumType.JUNGLE.func_181070_c());
    private static final BlockBark birchBark = new BlockBark("birchbark", BlockPlanks.EnumType.BIRCH.func_181070_c());
    private static final Block sugar = new BlockSugar("sugarblock");
    private static final Block flint = ((Block)new Block(Material.field_151595_p, MapColor.field_151650_B).func_149711_c(1.0f).func_149752_b(10.0f).func_149663_c("flintblock").setRegistryName("flintblock")).func_149647_a(CreativeTabs.field_78030_b);
    static boolean enableBarkBlocks;
    static boolean enableStorageBlocks;
    static boolean enablePedestal;
    private static Block[] blocks;

    @Override
    public void syncConfig(Configuration config, String category) {
        enableBarkBlocks = config.get(category, "enableBarkBlocks", true, "Want a block which has bark texture of logs in all sides?").getBoolean();
        enableStorageBlocks = config.get(category, "enableStorageBlocks", true, "Want block forms of flint, charcoal and sugar?").getBoolean();
        enablePedestal = config.get(category, "enablePedestal", true, "Want to showcase your treasure but item frame doesn't satisfy you?").getBoolean();
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks);
        GameRegistry.registerTileEntity(TileEntityPedestal.class, (ResourceLocation)pedestal.getRegistryName());
    }

    @SubscribeEvent
    public void onRegisterItemBlocks(RegistryEvent.Register<Item> event) {
        Arrays.stream(blocks).map(block -> (Item)new ItemBlock(block).setRegistryName(block.getRegistryName())).forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister(ModelRegistryEvent event) {
        Arrays.stream(blocks).map(Item::func_150898_a).forEach(item -> Utils.registerItemRenderer(item, 0));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPedestal.class, (TileEntitySpecialRenderer)new TESRPedestal());
    }

    @Override
    public void registerPacket(SimpleNetworkWrapper network) {
        network.registerMessage((IMessageHandler)new PacketUpdatePedestal.Handler(), PacketUpdatePedestal.class, 0, Side.CLIENT);
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (item == Item.func_150898_a((Block)charcoal)) {
            event.setBurnTime(16000);
        }
        if (item == Item.func_150898_a((Block)net.minecraft.init.Blocks.field_150478_aa)) {
            event.setBurnTime(400);
        }
        if (item == Item.func_150898_a((Block)acaciaBark) || item == Item.func_150898_a((Block)birchBark) || item == Item.func_150898_a((Block)darkOakBark) || item == Item.func_150898_a((Block)jungleBark) || item == Item.func_150898_a((Block)oakBark) || item == Item.func_150898_a((Block)spruceBark)) {
            event.setBurnTime(300);
        }
    }

    static {
        blocks = new Block[]{acaciaBark, darkOakBark, oakBark, spruceBark, jungleBark, birchBark, charcoal, sugar, flint, pedestal};
    }
}

