/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.items;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.compat.baubles.BaubleTools;
import io.github.strikerrocker.vt.content.items.ItemSlimeBucket;
import io.github.strikerrocker.vt.content.items.craftingpad.ItemCraftingPad;
import io.github.strikerrocker.vt.content.items.dynamite.EntityDynamite;
import io.github.strikerrocker.vt.content.items.dynamite.ItemDynamite;
import io.github.strikerrocker.vt.misc.Utils;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Items
extends Feature {
    private static final ItemArmor.ArmorMaterial binocular_material = EnumHelper.addArmorMaterial((String)"binoculars", (String)"vt:binoculars", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
    private static final Item binocular = ((Item)new ItemArmor(binocular_material, 0, EntityEquipmentSlot.HEAD).func_77625_d(1).setRegistryName("binoculars")).func_77655_b("binoculars");
    private static final Item lens = (Item)new Item().func_77655_b("lens").setRegistryName("lens");
    private static final Item friedEgg = ((Item)new ItemFood(5, 0.6f, false).setRegistryName("friedegg")).func_77655_b("friedegg");
    public static Item craftingPad = new ItemCraftingPad("pad");
    public static Item dynamite = new ItemDynamite("dynamite");
    public static boolean enablePad;
    static boolean enableDynamite;
    static boolean enableSlimeBucket;
    static float binocularZoomAmount;
    private static Item slimeBucket;
    private static Item baubleBino;

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        VanillaTweaks.logInfo("Registering Entities");
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntityDynamite.class).id(new ResourceLocation("vt", "dynamite"), 0).name("dynamite").tracker(64, 1, false).build());
    }

    @SubscribeEvent
    public void onFOVChange(FOVUpdateEvent event) {
        if (event.getEntity() != null && binocularZoomAmount != 0.0f) {
            ItemStack helmet = event.getEntity().func_184582_a(EntityEquipmentSlot.HEAD);
            if (!helmet.func_190926_b() && helmet.func_77973_b() == binocular) {
                event.setNewfov(event.getFov() / binocularZoomAmount);
            } else if (Loader.isModLoaded((String)"baubles") && BaubleTools.hasProbeGoggle(event.getEntity())) {
                event.setNewfov(event.getFov() / binocularZoomAmount);
            }
        }
    }

    @Override
    public void syncConfig(Configuration config, String category) {
        enablePad = config.get(category, "craftingPad", true, "Do you want a portable crafting table?").getBoolean();
        enableSlimeBucket = config.get(category, "slimeBucket", true, "Want to identity slime chunks in-game?").getBoolean();
        enableDynamite = config.get(category, "dynamite", true, "Want a less effective but throwable TNT?").getBoolean();
        binocularZoomAmount = (float)Utils.get(config, category, "binocularZoomAmount", 4.0, "How much do you want the binoculars to zoom? ( 0 = disabled)", true).setMinValue(0).setRequiresMcRestart(false).getDouble();
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        VanillaTweaks.logInfo("Registering Items");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{craftingPad, slimeBucket, dynamite, binocular, lens, friedEgg});
        if (Loader.isModLoaded((String)"baubles")) {
            baubleBino = BaubleTools.initBinocularBauble();
            event.getRegistry().register((IForgeRegistryEntry)baubleBino);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister(ModelRegistryEvent event) {
        Utils.registerItemRenderer(craftingPad, 0);
        Utils.registerItemRenderer(slimeBucket, 0);
        Utils.registerItemRenderer(dynamite, 0);
        Utils.registerItemRenderer(binocular, 0);
        Utils.registerItemRenderer(lens, 0);
        Utils.registerItemRenderer(friedEgg, 0);
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, manager -> new RenderSnowball(manager, dynamite, Minecraft.func_71410_x().func_175599_af()));
    }

    @Override
    public void preInit() {
        BlockDispenser.field_149943_a.func_82595_a((Object)dynamite, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntityDynamite(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GameRegistry.addSmelting((Item)net.minecraft.init.Items.field_151110_aK, (ItemStack)new ItemStack(friedEgg), (float)0.35f);
    }

    static {
        slimeBucket = new ItemSlimeBucket("slime");
    }
}

