/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import com.google.common.collect.Maps;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.enchantments.EnchantmentBlazing;
import io.github.strikerrocker.vt.enchantments.EnchantmentHoming;
import io.github.strikerrocker.vt.enchantments.EnchantmentHops;
import io.github.strikerrocker.vt.enchantments.EnchantmentNimble;
import io.github.strikerrocker.vt.enchantments.EnchantmentSiphon;
import io.github.strikerrocker.vt.enchantments.EnchantmentVeteran;
import io.github.strikerrocker.vt.enchantments.EnchantmentVigor;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentFeature
extends Feature {
    private Map<Enchantment, Tuple<String, String>> enchantments = Maps.newHashMap();
    private Object2BooleanOpenHashMap<Enchantment> enchantmentsToEnable = new Object2BooleanOpenHashMap();

    EnchantmentFeature() {
        this.enchantments.put(new EnchantmentBlazing("blazing"), (Tuple<String, String>)new Tuple((Object)"blazing", (Object)"Want to smelt things when you mine them?"));
        this.enchantments.put(new EnchantmentHops("hops"), (Tuple<String, String>)new Tuple((Object)"hops", (Object)"Want to jump more than a block high with an enchantment?"));
        this.enchantments.put(new EnchantmentNimble("nimble"), (Tuple<String, String>)new Tuple((Object)"nimble", (Object)"Want more speed with an enchantment?"));
        this.enchantments.put(new EnchantmentSiphon("siphon"), (Tuple<String, String>)new Tuple((Object)"siphon", (Object)"Don't want the zombies stealing your items when you are mining?"));
        this.enchantments.put(new EnchantmentVeteran("veteran"), (Tuple<String, String>)new Tuple((Object)"veteran", (Object)"Want all the experience in the nearby area?"));
        this.enchantments.put(new EnchantmentVigor("vigor"), (Tuple<String, String>)new Tuple((Object)"vigor", (Object)"Want more health with an enchant?"));
        this.enchantments.put(new EnchantmentHoming("homing"), (Tuple<String, String>)new Tuple((Object)"homing", (Object)"Don't want to aim but love shooting arrows?"));
        this.enchantments.forEach((enchantment, idDesc) -> MinecraftForge.EVENT_BUS.register(enchantment));
    }

    @Override
    public void syncConfig(Configuration config, String category) {
        this.enchantments.forEach((enchantment, tuple) -> this.enchantmentsToEnable.put(enchantment, config.get(category, (String)tuple.func_76341_a(), true, (String)tuple.func_76340_b()).setRequiresMcRestart(true).getBoolean()));
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> registryEvent) {
        this.enchantmentsToEnable.forEach((enchantment, toEnable) -> {
            if (toEnable.booleanValue()) {
                registryEvent.getRegistry().register((IForgeRegistryEntry)enchantment);
            }
        });
    }
}

