/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EnchantmentHoming
extends Enchantment {
    EnchantmentHoming(String name) {
        super(Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.BOW, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName(name);
        this.func_77322_b(name);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world != null) {
            event.world.func_175644_a(EntityArrow.class, EntitySelectors.field_94557_a).forEach(this::attemptToMove);
        }
    }

    private void attemptToMove(EntityArrow arrow) {
        EntityLivingBase shooter = (EntityLivingBase)arrow.field_70250_c;
        if (shooter != null && EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)shooter.func_184614_ca()) > 0) {
            int homingLevel = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)shooter.func_184614_ca());
            double distance = Math.pow(2.0, (double)homingLevel - 1.0) * 32.0;
            World world = arrow.field_70170_p;
            List livingEntities = world.func_175644_a(EntityLivingBase.class, EntitySelectors.field_180132_d);
            EntityLivingBase target = null;
            for (EntityLivingBase livingEntity : livingEntities) {
                double distanceToArrow = livingEntity.func_70032_d((Entity)arrow);
                if (!(distanceToArrow < distance) || !shooter.func_70685_l((Entity)livingEntity) || livingEntity.getPersistentID().equals(shooter.getPersistentID())) continue;
                distance = distanceToArrow;
                target = livingEntity;
            }
            if (target != null) {
                double x = target.field_70165_t - arrow.field_70165_t;
                double y = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (arrow.field_70163_u + (double)(arrow.field_70131_O / 2.0f));
                double z = target.field_70161_v - arrow.field_70161_v;
                arrow.func_70186_c(x, y, z, (float)Math.sqrt(Math.pow(2.0, arrow.field_70159_w) + Math.pow(2.0, arrow.field_70181_x) + Math.pow(2.0, arrow.field_70179_y)), 0.0f);
            }
        }
    }

    public int func_77321_a(int enchantmentLevel) {
        return (enchantmentLevel - 1) * 10 + 10;
    }

    public int func_77317_b(int enchantmentLevel) {
        return enchantmentLevel * 10 + 51;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBow;
    }
}

