/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks.silkspawner;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.tweaks.silkspawner.DummyMobSpawnerLogic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SilkSpawner
extends Feature {
    private static final String SPAWNER_TAG = "SilkSpawnerData";
    private boolean enableSilkSpawner;

    @Override
    public void syncConfig(Configuration config, String category) {
        this.enableSilkSpawner = config.get(category, "enableSilkSpawner", true, "Want the ability to move spawners with silk touch?").getBoolean();
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
        if (this.enableSilkSpawner && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150474_ac) && stack.func_77942_o()) {
            TileEntity tile;
            NBTTagCompound stackTag = stack.func_77978_p();
            assert (stackTag != null);
            NBTTagCompound spawnerDataNBT = stackTag.func_74775_l(SPAWNER_TAG);
            if (!spawnerDataNBT.func_82582_d() && (tile = event.getWorld().func_175625_s(event.getPos())) instanceof TileEntityMobSpawner) {
                ((TileEntityMobSpawner)tile).func_145881_a().func_98270_a(spawnerDataNBT);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        TileEntity tile = world.func_175625_s(event.getPos());
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)event.getPlayer().func_184614_ca());
        if (event.getState().func_177230_c() instanceof BlockMobSpawner && !world.field_72995_K && tile instanceof TileEntityMobSpawner && this.enableSilkSpawner && lvl >= 1) {
            event.setExpToDrop(0);
            ItemStack drop = new ItemStack(Blocks.field_150474_ac);
            NBTTagCompound spawnerData = ((TileEntityMobSpawner)tile).func_145881_a().func_189530_b(new NBTTagCompound());
            NBTTagCompound stackTag = new NBTTagCompound();
            spawnerData.func_82580_o("Delay");
            stackTag.func_74782_a(SPAWNER_TAG, (NBTBase)spawnerData);
            drop.func_77982_d(stackTag);
            Block.func_180635_a((World)world, (BlockPos)event.getPos(), (ItemStack)drop);
            world.func_175655_b(event.getPos(), false);
            world.func_175713_t(event.getPos());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onToolTipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77942_o()) {
            NBTTagCompound stackTag = stack.func_77978_p();
            assert (stackTag != null);
            NBTTagCompound spawnerDataNBT = stackTag.func_74775_l(SPAWNER_TAG);
            if (!spawnerDataNBT.func_82582_d()) {
                DummyMobSpawnerLogic.DUMMY_MOB_SPAWNER_LOGIC.func_98270_a(spawnerDataNBT);
                Entity ent = DummyMobSpawnerLogic.DUMMY_MOB_SPAWNER_LOGIC.func_184994_d();
                event.getToolTip().add(I18n.func_74837_a((String)"tooltip.entity", (Object[])new Object[]{ent.func_70005_c_()}));
            }
        }
    }
}

