/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world.selfplanting;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.world.selfplanting.ISelfPlanting;
import io.github.strikerrocker.vt.world.selfplanting.SelfPlanting;
import io.github.strikerrocker.vt.world.selfplanting.SelfPlantingProvider;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CapabilitySelfPlanting
extends Feature {
    @CapabilityInject(value=ISelfPlanting.class)
    static Capability<ISelfPlanting> CAPABILITY_PLANTING = null;
    private boolean selfPlanting;

    @Override
    public void syncConfig(Configuration config, String category) {
        this.selfPlanting = config.get(category, "selfPlanting", true, "Dropped seeds/crops now plant themselves").setRequiresMcRestart(true).getBoolean();
    }

    @Override
    public void preInit() {
        if (this.selfPlanting) {
            VanillaTweaks.logInfo("Registering self planting capability");
            CapabilityManager.INSTANCE.register(ISelfPlanting.class, (Capability.IStorage)new Capability.IStorage<ISelfPlanting>(){

                public NBTBase writeNBT(Capability<ISelfPlanting> capability, ISelfPlanting instance, EnumFacing side) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74768_a("MinSteadyTicks", instance.getMinSteadyTicks());
                    compound.func_74768_a("SteadyTicks", instance.getSteadyTicks());
                    return compound;
                }

                public void readNBT(Capability<ISelfPlanting> capability, ISelfPlanting instance, EnumFacing side, NBTBase nbt) {
                    NBTTagCompound compound = (NBTTagCompound)nbt;
                    instance.setMinSteadyTicks(compound.func_74762_e("MinSteadyTicks"));
                    instance.setSteadyTicks(compound.func_74762_e("SteadyTicks"));
                }
            }, SelfPlanting::new);
        }
    }

    @Override
    public boolean usesEvents() {
        return this.selfPlanting;
    }

    @SubscribeEvent
    public void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityItem) {
            event.addCapability(new ResourceLocation("vt", "planting"), (ICapabilityProvider)new SelfPlantingProvider());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (this.selfPlanting && !world.field_72995_K) {
            for (EntityItem entityItem : world.func_175644_a(EntityItem.class, EntitySelectors.field_94557_a)) {
                if (!entityItem.hasCapability(CAPABILITY_PLANTING, null)) continue;
                ((ISelfPlanting)Objects.requireNonNull(entityItem.getCapability(CAPABILITY_PLANTING, null))).handlePlantingLogic(entityItem);
            }
        }
    }
}

