/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.items;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.compat.baubles.BaubleTools;
import io.github.strikerrocker.vt.content.items.BasicArmorMaterial;
import io.github.strikerrocker.vt.content.items.ItemConditions;
import io.github.strikerrocker.vt.content.items.SlimeBucketItem;
import io.github.strikerrocker.vt.content.items.craftingpad.CraftingPadItem;
import io.github.strikerrocker.vt.content.items.dynamite.DynamiteEntity;
import io.github.strikerrocker.vt.content.items.dynamite.DynamiteItem;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Food;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class Items
extends Feature {
    @ObjectHolder(value="vanillatweaks:dynamite")
    public static final EntityType<DynamiteEntity> DYNAMITE_TYPE = null;
    private static final Item BINOCULARS = (Item)new ArmorItem((IArmorMaterial)new BasicArmorMaterial("vanillatweaks:binoculars", 0, new int[]{0, 0, 0, 0}, 0, SoundEvents.field_187725_r, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{net.minecraft.item.Items.field_151042_j})), EquipmentSlotType.HEAD, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i)).setRegistryName("binoculars");
    private static final Item LENS = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("lens");
    private static final Item FRIED_EGG = (Item)new Item(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.6f).func_221453_d()).func_200916_a(ItemGroup.field_78039_h)).setRegistryName("friedegg");
    public static Item CRAFTING_PAD = new CraftingPadItem();
    public static Item DYNAMITE = new DynamiteItem("dynamite");
    public static ForgeConfigSpec.BooleanValue enablePad;
    static ForgeConfigSpec.BooleanValue enableDynamite;
    static ForgeConfigSpec.BooleanValue enableSlimeBucket;
    static ForgeConfigSpec.DoubleValue binocularZoomAmount;
    static ForgeConfigSpec.BooleanValue enableFriedEgg;
    private static Item SLIME_BUCKET;
    private static Item BAUBLE_BINO;

    @SubscribeEvent
    public void onFOVChange(FOVUpdateEvent event) {
        if (event.getEntity() != null && (Double)binocularZoomAmount.get() != 0.0) {
            ItemStack helmet = event.getEntity().func_184582_a(EquipmentSlotType.HEAD);
            if (!helmet.func_190926_b() && helmet.func_77973_b() == BINOCULARS) {
                event.setNewfov((float)((double)event.getFov() / (Double)binocularZoomAmount.get()));
            } else if (ModList.get().isLoaded("baubles") && BaubleTools.hasProbeGoggle(event.getEntity())) {
                event.setNewfov((float)((double)event.getFov() / (Double)binocularZoomAmount.get()));
            }
        }
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        enablePad = builder.translation("config.vanillatweaks:enablePad").comment("Do you want a portable crafting table?").define("enablePad", true);
        enableSlimeBucket = builder.translation("config.vanillatweaks:enableSlimeBucket").comment("Want to identity slime chunks in-game?").define("enableSlimeBucket", true);
        enableDynamite = builder.translation("config.vanillatweaks:enableDynamite").comment("Want a less effective but throwable TNT?").define("enableDynamite", true);
        enableFriedEgg = builder.translation("config.vanillatweaks:enableFriedEgg").comment("Want a food which can be obtained with eggs and heals 2.5 hunger?").define("enableFriedEgg", true);
        binocularZoomAmount = builder.translation("config.vanillatweaks:binocularZoomAmount").comment("How much do you want the binoculars to zoom? ( 0 = disabled)").defineInRange("binocularZoomAmount", 4.0, 0.0, Double.MAX_VALUE);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setup() {
        DispenserBlock.func_199774_a((IItemProvider)DYNAMITE, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new DynamiteEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
    }

    static {
        SLIME_BUCKET = new SlimeBucketItem();
    }

    @Mod.EventBusSubscriber(modid="vanillatweaks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @SubscribeEvent
        public static void onModelRegister(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler(DynamiteEntity.class, manager -> new SpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().register(EntityType.Builder.func_220322_a(DynamiteEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> (DynamiteEntity)DYNAMITE_TYPE.func_200721_a(world)).setTrackingRange(64).setUpdateInterval(20).func_206830_a("vanillatweaks:dynamite").setRegistryName(new ResourceLocation("vanillatweaks", "dynamite")));
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            CraftingHelper.register((IConditionSerializer)ItemConditions.Serializer.INSTANCE);
        }

        @SubscribeEvent
        public static void onRegisterItems(RegistryEvent.Register<Item> event) {
            VanillaTweaks.LOGGER.info("Registering Items");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{CRAFTING_PAD, SLIME_BUCKET, DYNAMITE, BINOCULARS, LENS, FRIED_EGG});
            if (ModList.get().isLoaded("baubles")) {
                BAUBLE_BINO = BaubleTools.initBinocularBauble();
                event.getRegistry().register((IForgeRegistryEntry)BAUBLE_BINO);
            }
        }
    }
}

